/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.IHasCSSDeclarations;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclarationList
implements IHasCSSDeclarations,
ICSSSourceLocationAware {
    private final List<CSSDeclaration> m_aDeclarations = new ArrayList<CSSDeclaration>();
    private CSSSourceLocation m_aSourceLocation;

    @Override
    public final void addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        if (cSSDeclaration == null) {
            throw new NullPointerException("declaration");
        }
        this.m_aDeclarations.add(cSSDeclaration);
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return EChange.valueOf((boolean)this.m_aDeclarations.remove(cSSDeclaration));
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aDeclarations.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aDeclarations.remove(n) != null ? 1 : 0) != 0);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<CSSDeclaration> getAllDeclarations() {
        return ContainerHelper.newList(this.m_aDeclarations);
    }

    @Override
    @Nullable
    public final CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return (CSSDeclaration)ContainerHelper.getSafe(this.m_aDeclarations, (int)n);
    }

    @Override
    public boolean hasDeclarations() {
        return !this.m_aDeclarations.isEmpty();
    }

    @Override
    @Nonnegative
    public final int getDeclarationCount() {
        return this.m_aDeclarations.size();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        int n2 = this.m_aDeclarations.size();
        if (n2 == 0) {
            return "";
        }
        if (n2 == 1) {
            return ((CSSDeclaration)ContainerHelper.getFirstElement(this.m_aDeclarations)).getAsCSSString(iCSSWriterSettings, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (CSSDeclaration cSSDeclaration : this.m_aDeclarations) {
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
            }
            stringBuilder.append(cSSDeclaration.getAsCSSString(iCSSWriterSettings, n + 1));
            if (bl) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSDeclarationList)) {
            return false;
        }
        CSSDeclarationList cSSDeclarationList = (CSSDeclarationList)object;
        return ((Object)this.m_aDeclarations).equals(cSSDeclarationList.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declarations", this.m_aDeclarations).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

