/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpressionMemberTermSimple;
import com.phloc.css.decl.CSSExpressionMemberTermURI;
import com.phloc.css.decl.ECSSExpressionOperator;
import com.phloc.css.decl.ICSSExpressionMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSExpression
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final List<ICSSExpressionMember> m_aMembers = new ArrayList<ICSSExpressionMember>();
    private CSSSourceLocation m_aSourceLocation;

    @Nonnull
    public CSSExpression addMember(@Nonnull ICSSExpressionMember iCSSExpressionMember) {
        if (iCSSExpressionMember == null) {
            throw new NullPointerException("member");
        }
        this.m_aMembers.add(iCSSExpressionMember);
        return this;
    }

    @Nonnull
    public CSSExpression addTermSimple(@Nonnull @Nonempty String string) {
        return this.addMember(new CSSExpressionMemberTermSimple(string));
    }

    @Nonnull
    public CSSExpression addNumber(int n) {
        return this.addMember(new CSSExpressionMemberTermSimple(n));
    }

    @Nonnull
    public CSSExpression addNumber(long l) {
        return this.addMember(new CSSExpressionMemberTermSimple(l));
    }

    @Nonnull
    public CSSExpression addNumber(float f) {
        return this.addMember(new CSSExpressionMemberTermSimple(f));
    }

    @Nonnull
    public CSSExpression addNumber(double d) {
        return this.addMember(new CSSExpressionMemberTermSimple(d));
    }

    @Nonnull
    public CSSExpression addString(@Nonnull String string) {
        String string2 = StringHelper.replaceAll((String)string, (String)"\"", (CharSequence)"\\\"");
        return this.addTermSimple('\"' + string2 + '\"');
    }

    @Nonnull
    public CSSExpression addURI(@Nonnull @Nonempty String string) {
        return this.addMember(new CSSExpressionMemberTermURI(string));
    }

    @Nonnull
    public EChange removeMember(@Nullable ICSSExpressionMember iCSSExpressionMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(iCSSExpressionMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSExpressionMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Nullable
    public ICSSExpressionMember getMemberAtIndex(@Nonnegative int n) {
        return (ICSSExpressionMember)ContainerHelper.getSafe(this.m_aMembers, (int)n);
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public List<CSSExpressionMemberTermSimple> getAllSimpleMembers() {
        ArrayList<CSSExpressionMemberTermSimple> arrayList = new ArrayList<CSSExpressionMemberTermSimple>();
        for (ICSSExpressionMember iCSSExpressionMember : this.m_aMembers) {
            if (!(iCSSExpressionMember instanceof CSSExpressionMemberTermSimple)) continue;
            arrayList.add((CSSExpressionMemberTermSimple)iCSSExpressionMember);
        }
        return arrayList;
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (ICSSExpressionMember iCSSExpressionMember : this.m_aMembers) {
            boolean bl2 = iCSSExpressionMember instanceof ECSSExpressionOperator;
            if (!bl2 && !bl && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(iCSSExpressionMember.getAsCSSString(iCSSWriterSettings, n));
            bl = bl2;
        }
        return stringBuilder.toString();
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSExpression)) {
            return false;
        }
        CSSExpression cSSExpression = (CSSExpression)object;
        return ((Object)this.m_aMembers).equals(cSSExpression.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }

    @Nonnull
    public static CSSExpression createSimple(@Nonnull @Nonempty String string) {
        return new CSSExpression().addTermSimple(string);
    }

    @Nonnull
    public static CSSExpression createString(@Nonnull @Nonempty String string) {
        return new CSSExpression().addString(string);
    }

    @Nonnull
    public static CSSExpression createNumber(int n) {
        return new CSSExpression().addNumber(n);
    }

    @Nonnull
    public static CSSExpression createNumber(long l) {
        return new CSSExpression().addNumber(l);
    }

    @Nonnull
    public static CSSExpression createNumber(float f) {
        return new CSSExpression().addNumber(f);
    }

    @Nonnull
    public static CSSExpression createNumber(double d) {
        return new CSSExpression().addNumber(d);
    }

    @Nonnull
    public static CSSExpression createURI(@Nonnull @Nonempty String string) {
        return new CSSExpression().addURI(string);
    }
}

