/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSExpressionMathMember;
import com.phloc.css.decl.ICSSExpressionMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSExpressionMemberMath
implements ICSSExpressionMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final List<ICSSExpressionMathMember> m_aMembers = new ArrayList<ICSSExpressionMathMember>();
    private CSSSourceLocation m_aSourceLocation;

    public void addMember(@Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        if (iCSSExpressionMathMember == null) {
            throw new NullPointerException("member");
        }
        this.m_aMembers.add(iCSSExpressionMathMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(iCSSExpressionMathMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSExpressionMathMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder("calc(");
        for (ICSSExpressionMathMember iCSSExpressionMathMember : this.m_aMembers) {
            stringBuilder.append(iCSSExpressionMathMember.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.append(")").toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSExpressionMemberMath)) {
            return false;
        }
        CSSExpressionMemberMath cSSExpressionMemberMath = (CSSExpressionMemberMath)object;
        return ((Object)this.m_aMembers).equals(cSSExpressionMemberMath.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

