/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpressionTermOptimizer;
import com.phloc.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSExpressionMemberTermSimple
implements ICSSExpressionMember,
ICSSSourceLocationAware {
    private String m_sValue;
    private String m_sOptimizedValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberTermSimple(int n) {
        this(Integer.toString(n));
    }

    public CSSExpressionMemberTermSimple(long l) {
        this(Long.toString(l));
    }

    public CSSExpressionMemberTermSimple(float f) {
        this(Float.toString(f));
    }

    public CSSExpressionMemberTermSimple(double d) {
        this(Double.toString(d));
    }

    public CSSExpressionMemberTermSimple(@Nonnull @Nonempty String string) {
        this.setValue(string);
    }

    public void setValue(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("Empty value is not allowed");
        }
        this.m_sValue = string;
        this.m_sOptimizedValue = CSSExpressionTermOptimizer.getOptimizedValue(string);
    }

    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    @Nonempty
    public String getOptimizedValue() {
        return this.m_sOptimizedValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return iCSSWriterSettings.isOptimizedOutput() ? this.m_sOptimizedValue : this.m_sValue;
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSExpressionMemberTermSimple)) {
            return false;
        }
        CSSExpressionMemberTermSimple cSSExpressionMemberTermSimple = (CSSExpressionMemberTermSimple)object;
        return this.m_sOptimizedValue.equals(cSSExpressionMemberTermSimple.m_sOptimizedValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sOptimizedValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("value", (Object)this.m_sValue).append("optimizedValue", (Object)this.m_sOptimizedValue).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

