/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.CSSURI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSImportRule
implements ICSSWriteable,
ICSSSourceLocationAware {
    private CSSURI m_aLocation;
    private final List<CSSMediaQuery> m_aMediaQueries = new ArrayList<CSSMediaQuery>();
    private CSSSourceLocation m_aSourceLocation;

    public CSSImportRule(@Nonnull CSSURI cSSURI) {
        this.setLocation(cSSURI);
    }

    public boolean hasMediaQueries() {
        return !this.m_aMediaQueries.isEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    public void addMediaQuery(@Nonnull CSSMediaQuery cSSMediaQuery) {
        if (cSSMediaQuery == null) {
            throw new NullPointerException("mediaQuery");
        }
        this.m_aMediaQueries.add(cSSMediaQuery);
    }

    public void addMediaQuery(@Nonnegative int n, @Nonnull CSSMediaQuery cSSMediaQuery) {
        if (cSSMediaQuery == null) {
            throw new NullPointerException("mediaQuery");
        }
        this.m_aMediaQueries.add(n, cSSMediaQuery);
    }

    @Nonnull
    public EChange removeMediaQuery(@Nullable CSSMediaQuery cSSMediaQuery) {
        return EChange.valueOf((boolean)this.m_aMediaQueries.remove(cSSMediaQuery));
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMediaQueries.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaQuery> getAllMediaQueries() {
        return ContainerHelper.newList(this.m_aMediaQueries);
    }

    @Nonnull
    public CSSURI getLocation() {
        return this.m_aLocation;
    }

    @Nonnull
    public String getLocationString() {
        return this.m_aLocation.getURI();
    }

    public void setLocation(@Nonnull CSSURI cSSURI) {
        if (cSSURI == null) {
            throw new NullPointerException("location");
        }
        this.m_aLocation = cSSURI;
    }

    public void setLocationString(@Nonnull @Nonempty String string) {
        this.m_aLocation.setURI(string);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@import ").append(this.m_aLocation.getAsCSSString(iCSSWriterSettings, n));
        if (!this.m_aMediaQueries.isEmpty()) {
            stringBuilder.append(' ');
            boolean bl2 = true;
            for (CSSMediaQuery cSSMediaQuery : this.m_aMediaQueries) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(bl ? "," : ", ");
                }
                stringBuilder.append(cSSMediaQuery.getAsCSSString(iCSSWriterSettings, n));
            }
        }
        return stringBuilder.append(";\n").toString();
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSImportRule)) {
            return false;
        }
        CSSImportRule cSSImportRule = (CSSImportRule)object;
        return this.m_aLocation.equals(cSSImportRule.m_aLocation) && ((Object)this.m_aMediaQueries).equals(cSSImportRule.m_aMediaQueries);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLocation).append(this.m_aMediaQueries).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("location", (Object)this.m_aLocation).append("mediaQueries", this.m_aMediaQueries).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

