/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.media.ECSSMediaExpressionFeature;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CSSMediaExpression
implements ICSSWriteable,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final String m_sFeature;
    private final CSSExpression m_aValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSMediaExpression(@Nonnull ECSSMediaExpressionFeature eCSSMediaExpressionFeature) {
        this(eCSSMediaExpressionFeature.getName());
    }

    public CSSMediaExpression(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public CSSMediaExpression(@Nonnull ECSSMediaExpressionFeature eCSSMediaExpressionFeature, @Nullable CSSExpression cSSExpression) {
        this(eCSSMediaExpressionFeature.getName(), cSSExpression);
    }

    public CSSMediaExpression(@Nonnull @Nonempty String string, @Nullable CSSExpression cSSExpression) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("feature");
        }
        this.m_sFeature = string;
        this.m_aValue = cSSExpression;
    }

    @Nonnull
    @Nonempty
    public String getFeature() {
        return this.m_sFeature;
    }

    @Nullable
    public CSSExpression getValue() {
        return this.m_aValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder("(").append(this.m_sFeature);
        if (this.m_aValue != null) {
            stringBuilder.append(':').append(this.m_aValue.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSMediaExpression)) {
            return false;
        }
        CSSMediaExpression cSSMediaExpression = (CSSMediaExpression)object;
        return this.m_sFeature.equals(cSSMediaExpression.m_sFeature) && EqualsUtils.equals((Object)this.m_aValue, (Object)cSSMediaExpression.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFeature).append((Object)this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("feature", (Object)this.m_sFeature).appendIfNotNull("value", (Object)this.m_aValue).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

