/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSMediaRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final List<CSSMediaQuery> m_aMediaQueries = new ArrayList<CSSMediaQuery>();
    private final List<ICSSTopLevelRule> m_aRules = new ArrayList<ICSSTopLevelRule>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMediaQueries() {
        return !this.m_aMediaQueries.isEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    public void addMediaQuery(@Nonnull @Nonempty CSSMediaQuery cSSMediaQuery) {
        if (cSSMediaQuery == null) {
            throw new NullPointerException("mediaQuery");
        }
        this.m_aMediaQueries.add(cSSMediaQuery);
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnull CSSMediaQuery cSSMediaQuery) {
        return EChange.valueOf((boolean)this.m_aMediaQueries.remove(cSSMediaQuery));
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMediaQueries.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.remove(n);
        return EChange.CHANGED;
    }

    @Nullable
    public CSSMediaQuery getMediaQueryAtIndex(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMediaQueries.size()) {
            return null;
        }
        return this.m_aMediaQueries.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaQuery> getAllMediaQueries() {
        return ContainerHelper.newList(this.m_aMediaQueries);
    }

    public boolean hasRules() {
        return !this.m_aRules.isEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    public void addRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        if (iCSSTopLevelRule == null) {
            throw new NullPointerException("rule");
        }
        this.m_aRules.add(iCSSTopLevelRule);
    }

    @Nonnull
    public EChange removeRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove(iCSSTopLevelRule));
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.remove(n);
        return EChange.CHANGED;
    }

    @Nullable
    public ICSSTopLevelRule getRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aRules.size()) {
            return null;
        }
        return this.m_aRules.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSTopLevelRule> getAllRules() {
        return ContainerHelper.newList(this.m_aRules);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteMediaRules()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        int n2 = this.m_aRules.size();
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("@media ");
        boolean bl2 = true;
        for (CSSMediaQuery iCSSWriteable : this.m_aMediaQueries) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(bl ? "," : ", ");
            }
            stringBuilder.append(iCSSWriteable.getAsCSSString(iCSSWriterSettings, n));
        }
        if (n2 == 0) {
            stringBuilder.append(bl ? "{}" : " {}\n");
        } else {
            stringBuilder.append(bl ? "{" : " {\n");
            bl2 = true;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                String string = iCSSTopLevelRule.getAsCSSString(iCSSWriterSettings, n + 1);
                if (!StringHelper.hasText((String)string)) continue;
                if (bl2) {
                    bl2 = false;
                } else if (!bl) {
                    stringBuilder.append('\n');
                }
                if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
                }
                stringBuilder.append(string);
            }
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
            if (!bl) {
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSMediaRule)) {
            return false;
        }
        CSSMediaRule cSSMediaRule = (CSSMediaRule)object;
        return ((Object)this.m_aMediaQueries).equals(cSSMediaRule.m_aMediaQueries) && ((Object)this.m_aRules).equals(cSSMediaRule.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMediaQueries).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("mediaQueries", this.m_aMediaQueries).append("styleRules", this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

