/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSSelectorMemberFunctionLike
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sFuncName;
    private final CSSExpression m_aParamExpr;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberFunctionLike(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("empty function name is not allowed");
        }
        if (!string.endsWith("(")) {
            throw new IllegalArgumentException("function name must end with a '('");
        }
        if (cSSExpression == null) {
            throw new NullPointerException("paramExpr");
        }
        this.m_sFuncName = string;
        this.m_aParamExpr = cSSExpression;
    }

    @Nonnull
    @Nonempty
    public String getFunctionName() {
        return this.m_sFuncName;
    }

    @Nonnull
    public CSSExpression getParameterExpression() {
        return this.m_aParamExpr;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sFuncName + this.m_aParamExpr.getAsCSSString(iCSSWriterSettings, n) + ')';
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSSelectorMemberFunctionLike)) {
            return false;
        }
        CSSSelectorMemberFunctionLike cSSSelectorMemberFunctionLike = (CSSSelectorMemberFunctionLike)object;
        return this.m_sFuncName.equals(cSSSelectorMemberFunctionLike.m_sFuncName) && this.m_aParamExpr.equals(cSSSelectorMemberFunctionLike.m_aParamExpr);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFuncName).append((Object)this.m_aParamExpr).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("functionName", (Object)this.m_sFuncName).append("paramExpr", (Object)this.m_aParamExpr).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

