/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSSelectorMember;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSSelectorMemberNot
implements ICSSSelectorMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final List<ICSSSelectorMember> m_aNestedSelectorMembers;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberNot(@Nonnull List<ICSSSelectorMember> list) {
        if (list == null) {
            throw new NullPointerException("nestedSelectorMembers");
        }
        this.m_aNestedSelectorMembers = list;
    }

    @Nonnegative
    public int getNestedMemberCount() {
        return this.m_aNestedSelectorMembers.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSSelectorMember> getNestedMembers() {
        return ContainerHelper.newList(this.m_aNestedSelectorMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder(":not(");
        for (ICSSSelectorMember iCSSSelectorMember : this.m_aNestedSelectorMembers) {
            stringBuilder.append(iCSSSelectorMember.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSSelectorMemberNot)) {
            return false;
        }
        CSSSelectorMemberNot cSSSelectorMemberNot = (CSSSelectorMemberNot)object;
        return ((Object)this.m_aNestedSelectorMembers).equals(cSSSelectorMemberNot.m_aNestedSelectorMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aNestedSelectorMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("nestedSelectorMembers", this.m_aNestedSelectorMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

