/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.utils.CSSURLHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSURI
implements ICSSWriteable,
ICSSSourceLocationAware {
    private String m_sURI;
    private CSSSourceLocation m_aSourceLocation;

    public CSSURI(@Nonnull @Nonempty String string) {
        this.setURI(string);
    }

    @Nonnull
    @Nonempty
    public String getURI() {
        return this.m_sURI;
    }

    public void setURI(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("URI may not be empty");
        }
        if (CSSURLHelper.isURLValue(string)) {
            throw new IllegalArgumentException("Only the URI and not the CSS URI value must be passed!");
        }
        this.m_sURI = string;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return CSSURLHelper.getAsCSSURL(this.m_sURI, iCSSWriterSettings.isQuoteURLs());
    }

    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSURI)) {
            return false;
        }
        CSSURI cSSURI = (CSSURI)object;
        return this.m_sURI.equals(cSSURI.m_sURI);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("URI", (Object)this.m_sURI).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

