/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.handler;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSDeclarationList;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.CSSExpressionMemberFunction;
import com.phloc.css.decl.CSSExpressionMemberMath;
import com.phloc.css.decl.CSSExpressionMemberMathProduct;
import com.phloc.css.decl.CSSExpressionMemberMathUnitProduct;
import com.phloc.css.decl.CSSExpressionMemberMathUnitSimple;
import com.phloc.css.decl.CSSExpressionMemberTermSimple;
import com.phloc.css.decl.CSSExpressionMemberTermURI;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesBlock;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaExpression;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSNamespaceRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.CSSSelectorAttribute;
import com.phloc.css.decl.CSSSelectorMemberFunctionLike;
import com.phloc.css.decl.CSSSelectorMemberNot;
import com.phloc.css.decl.CSSSelectorSimpleMember;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.CSSURI;
import com.phloc.css.decl.CSSViewportRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ECSSAttributeOperator;
import com.phloc.css.decl.ECSSExpressionOperator;
import com.phloc.css.decl.ECSSMathOperator;
import com.phloc.css.decl.ECSSSelectorCombinator;
import com.phloc.css.decl.ICSSExpressionMathMember;
import com.phloc.css.decl.ICSSExpressionMember;
import com.phloc.css.decl.ICSSSelectorMember;
import com.phloc.css.handler.ECSSNodeType;
import com.phloc.css.media.ECSSMediaExpressionFeature;
import com.phloc.css.media.ECSSMedium;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.ParseUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CSSNodeToDomainObject {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSNodeToDomainObject.class);
    private final ECSSVersion m_eVersion;

    public CSSNodeToDomainObject(@Nonnull ECSSVersion eCSSVersion) {
        if (eCSSVersion == null) {
            throw new NullPointerException("version");
        }
        this.m_eVersion = eCSSVersion;
    }

    private void _expectNodeType(@Nonnull CSSNode cSSNode, @Nonnull ECSSNodeType eCSSNodeType) {
        if (!eCSSNodeType.isNode(cSSNode, this.m_eVersion)) {
            throw new IllegalArgumentException("Expected a '" + eCSSNodeType.getNodeName(this.m_eVersion) + "' node but received a '" + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + "' node: " + cSSNode);
        }
    }

    private static void _throwUnexpectedChildrenCount(@Nonnull @Nonempty String string, @Nonnull CSSNode cSSNode) {
        s_aLogger.warn(string);
        for (int i = 0; i < cSSNode.jjtGetNumChildren(); ++i) {
            s_aLogger.warn("  " + cSSNode.jjtGetChild(i));
        }
        throw new IllegalArgumentException(string);
    }

    @Nonnull
    private CSSImportRule _createImportRule(CSSNode cSSNode) {
        Object object;
        this._expectNodeType(cSSNode, ECSSNodeType.IMPORTRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount("Expected at last 2 children but got " + n + "!", cSSNode);
        }
        CSSURI cSSURI = null;
        int n2 = 0;
        if (n > 0) {
            object = cSSNode.jjtGetChild(0);
            if (ECSSNodeType.URI.isNode((CSSNode)object, this.m_eVersion)) {
                cSSURI = new CSSURI(((CSSNode)object).getText());
                cSSURI.setSourceLocation(((CSSNode)object).getSourceLocation());
                ++n2;
            } else if (!ECSSNodeType.MEDIALIST.isNode((CSSNode)object, this.m_eVersion)) {
                throw new IllegalStateException("Expected an URI or MEDIALIST node but got " + ECSSNodeType.getNodeName((CSSNode)object, this.m_eVersion));
            }
        }
        if (cSSURI == null) {
            cSSURI = new CSSURI(ParseUtils.extractStringValue(cSSNode.getText()));
        }
        object = new CSSImportRule(cSSURI);
        ((CSSImportRule)object).setSourceLocation(cSSNode.getSourceLocation());
        if (n > n2) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
            if (ECSSNodeType.MEDIALIST.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    ((CSSImportRule)object).addMediaQuery(this._createMediaQuery(cSSNode3));
                }
            } else {
                throw new IllegalStateException("Expected an mediaList node but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
            }
            ++n2;
        }
        if (n2 < n) {
            s_aLogger.warn("Import statement has children which are unhandled.");
        }
        return object;
    }

    @Nonnull
    private CSSSelectorAttribute _createSelectorAttribute(@Nonnull CSSNode cSSNode) {
        CSSSelectorAttribute cSSSelectorAttribute;
        this._expectNodeType(cSSNode, ECSSNodeType.ATTRIB);
        int n = cSSNode.jjtGetNumChildren();
        String string = null;
        int n2 = 0;
        if (n > 0 && ECSSNodeType.NAMESPACEPREFIX.isNode(cSSNode.jjtGetChild(0), this.m_eVersion)) {
            string = cSSNode.jjtGetChild(0).getText();
            n2 = 1;
        }
        String string2 = cSSNode.getText();
        if (n == n2) {
            cSSSelectorAttribute = new CSSSelectorAttribute(string, string2);
        } else {
            int n3 = n2 + 2;
            if (n != n3) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount("Illegal number of children present (" + n + ") - expected " + n3, cSSNode);
            }
            CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
            this._expectNodeType(cSSNode2, ECSSNodeType.ATTRIBOPERATOR);
            CSSNode cSSNode3 = cSSNode.jjtGetChild(n2 + 1);
            this._expectNodeType(cSSNode3, ECSSNodeType.ATTRIBVALUE);
            cSSSelectorAttribute = new CSSSelectorAttribute(string, string2, ECSSAttributeOperator.getFromNameOrNull(cSSNode2.getText()), cSSNode3.getText());
        }
        cSSSelectorAttribute.setSourceLocation(cSSNode.getSourceLocation());
        return cSSSelectorAttribute;
    }

    @Nullable
    private ICSSSelectorMember _createSelectorMember(CSSNode cSSNode) {
        int n = cSSNode.jjtGetNumChildren();
        if (ECSSNodeType.NAMESPACEPREFIX.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.ELEMENTNAME.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.HASH.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.CLASS.isNode(cSSNode, this.m_eVersion)) {
            if (n != 0) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount("CSS simple selector member expected 0 children and got " + n, cSSNode);
            }
            CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText());
            cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
            return cSSSelectorSimpleMember;
        }
        if (ECSSNodeType.ATTRIB.isNode(cSSNode, this.m_eVersion)) {
            return this._createSelectorAttribute(cSSNode);
        }
        if (ECSSNodeType.COMBINATOR.isNode(cSSNode, this.m_eVersion)) {
            String string = cSSNode.getText();
            ECSSSelectorCombinator eCSSSelectorCombinator = ECSSSelectorCombinator.getFromNameOrNull(string);
            if (eCSSSelectorCombinator == null) {
                s_aLogger.warn("Failed to parse CSS selector combinator '" + string + "'");
            }
            return eCSSSelectorCombinator;
        }
        if (ECSSNodeType.NEGATION.isNode(cSSNode, this.m_eVersion)) {
            if (n > 2) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount("CSS Negation expected 1 or 2 children and got " + n, cSSNode);
            }
            ArrayList<ICSSSelectorMember> arrayList = new ArrayList<ICSSSelectorMember>(n);
            for (int i = 0; i < n; ++i) {
                CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
                arrayList.add(this._createSelectorMember(cSSNode2));
            }
            CSSSelectorMemberNot cSSSelectorMemberNot = new CSSSelectorMemberNot(arrayList);
            cSSSelectorMemberNot.setSourceLocation(cSSNode.getSourceLocation());
            return cSSSelectorMemberNot;
        }
        if (ECSSNodeType.PSEUDO.isNode(cSSNode, this.m_eVersion)) {
            if (n == 0) {
                CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText());
                cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
                return cSSSelectorSimpleMember;
            }
            if (n == 1) {
                CSSNode cSSNode3 = cSSNode.jjtGetChild(0);
                if (ECSSNodeType.NTH.isNode(cSSNode3, this.m_eVersion)) {
                    CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText() + cSSNode3.getText() + ")");
                    cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
                    return cSSSelectorSimpleMember;
                }
                CSSExpression cSSExpression = this._createExpression(cSSNode3);
                CSSSelectorMemberFunctionLike cSSSelectorMemberFunctionLike = new CSSSelectorMemberFunctionLike(cSSNode.getText(), cSSExpression);
                cSSSelectorMemberFunctionLike.setSourceLocation(cSSNode.getSourceLocation());
                return cSSSelectorMemberFunctionLike;
            }
            throw new UnsupportedOperationException("Not supporting pseudo-selectors with functions and " + n + " args: " + cSSNode.toString());
        }
        s_aLogger.warn("Unsupported selector child: " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion));
        return null;
    }

    @Nonnull
    private CSSSelector _createSelector(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.SELECTOR);
        CSSSelector cSSSelector = new CSSSelector();
        cSSSelector.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            ICSSSelectorMember iCSSSelectorMember = this._createSelectorMember(cSSNode2);
            if (iCSSSelectorMember == null) continue;
            cSSSelector.addMember(iCSSSelectorMember);
        }
        return cSSSelector;
    }

    @Nonnull
    private CSSExpressionMemberMathProduct _createExpressionMathProduct(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MATH_PRODUCT);
        CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = new CSSExpressionMemberMathProduct();
        cSSExpressionMemberMathProduct.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            Object object;
            if (ECSSNodeType.MATH_UNIT.isNode(cSSNode2, this.m_eVersion)) {
                int n = cSSNode2.jjtGetNumChildren();
                if (n == 0) {
                    object = new CSSExpressionMemberMathUnitSimple(cSSNode2.getText());
                    ((CSSExpressionMemberMathUnitSimple)object).setSourceLocation(cSSNode2.getSourceLocation());
                    cSSExpressionMemberMathProduct.addMember((ICSSExpressionMathMember)object);
                    continue;
                }
                if (n != 1) {
                    CSSNodeToDomainObject._throwUnexpectedChildrenCount("CSS math unit expected 1 child and got " + n, cSSNode2);
                }
                object = cSSNode2.jjtGetChild(0);
                CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct2 = this._createExpressionMathProduct((CSSNode)object);
                CSSExpressionMemberMathUnitProduct cSSExpressionMemberMathUnitProduct = new CSSExpressionMemberMathUnitProduct(cSSExpressionMemberMathProduct2);
                cSSExpressionMemberMathProduct.addMember(cSSExpressionMemberMathUnitProduct);
                continue;
            }
            if (ECSSNodeType.MATH_PRODUCTOPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                object = ECSSMathOperator.getFromNameOrNull(string);
                if (object == null) {
                    s_aLogger.warn("Failed to parse math product operator '" + string + "'");
                    continue;
                }
                cSSExpressionMemberMathProduct.addMember((ICSSExpressionMathMember)object);
                continue;
            }
            s_aLogger.warn("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpressionMemberMathProduct;
    }

    @Nonnull
    private CSSExpressionMemberMath _createExpressionMathTerm(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MATH);
        CSSExpressionMemberMath cSSExpressionMemberMath = new CSSExpressionMemberMath();
        cSSExpressionMemberMath.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.MATH_PRODUCT.isNode(cSSNode2, this.m_eVersion)) {
                cSSExpressionMemberMath.addMember(this._createExpressionMathProduct(cSSNode2));
                continue;
            }
            if (ECSSNodeType.MATH_SUMOPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                ECSSMathOperator eCSSMathOperator = ECSSMathOperator.getFromNameOrNull(string);
                if (eCSSMathOperator == null) {
                    s_aLogger.warn("Failed to parse math operator '" + string + "'");
                    continue;
                }
                cSSExpressionMemberMath.addMember(eCSSMathOperator);
                continue;
            }
            s_aLogger.warn("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpressionMemberMath;
    }

    @Nonnull
    private ICSSExpressionMember _createExpressionTerm(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.TERM);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 1) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount("Expected 0 or 1 children but got " + n + "!", cSSNode);
        }
        if (n == 0) {
            CSSExpressionMemberTermSimple cSSExpressionMemberTermSimple = new CSSExpressionMemberTermSimple(cSSNode.getText());
            cSSExpressionMemberTermSimple.setSourceLocation(cSSNode.getSourceLocation());
            return cSSExpressionMemberTermSimple;
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        int n2 = cSSNode2.jjtGetNumChildren();
        if (ECSSNodeType.URI.isNode(cSSNode2, this.m_eVersion)) {
            if (n2 > 0) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount("Expected 0 children but got " + n2 + "!", cSSNode2);
            }
            CSSURI cSSURI = new CSSURI(cSSNode2.getText());
            cSSURI.setSourceLocation(cSSNode2.getSourceLocation());
            return new CSSExpressionMemberTermURI(cSSURI);
        }
        if (ECSSNodeType.FUNCTION.isNode(cSSNode2, this.m_eVersion)) {
            CSSExpressionMemberFunction cSSExpressionMemberFunction;
            if (n2 > 1) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount("Expected 0 or 1 children but got " + n2 + "!", cSSNode2);
            }
            String string = cSSNode2.getText();
            if (n2 == 1) {
                CSSExpression cSSExpression = this._createExpression(cSSNode2.jjtGetChild(0));
                cSSExpressionMemberFunction = new CSSExpressionMemberFunction(string, cSSExpression);
            } else {
                cSSExpressionMemberFunction = new CSSExpressionMemberFunction(string);
            }
            cSSExpressionMemberFunction.setSourceLocation(cSSNode2.getSourceLocation());
            return cSSExpressionMemberFunction;
        }
        if (ECSSNodeType.MATH.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionMathTerm(cSSNode2);
        }
        throw new IllegalStateException("Expected an expression term but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
    }

    @Nonnull
    private CSSExpression _createExpression(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.EXPR);
        CSSExpression cSSExpression = new CSSExpression();
        cSSExpression.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.TERM.isNode(cSSNode2, this.m_eVersion)) {
                cSSExpression.addMember(this._createExpressionTerm(cSSNode2));
                continue;
            }
            if (ECSSNodeType.OPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                ECSSExpressionOperator eCSSExpressionOperator = ECSSExpressionOperator.getFromNameOrNull(string);
                if (eCSSExpressionOperator == null) {
                    s_aLogger.warn("Failed to parse expression operator '" + string + "'");
                    continue;
                }
                cSSExpression.addMember(eCSSExpressionOperator);
                continue;
            }
            s_aLogger.warn("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpression;
    }

    @Nonnull
    private CSSDeclaration _createDeclaration(@Nonnull CSSNode cSSNode) {
        Object object;
        this._expectNodeType(cSSNode, ECSSNodeType.DECLARATION);
        int n = cSSNode.jjtGetNumChildren();
        if (n != 2 && n != 3) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount("Expected 2 or 3 children but got " + n + "!", cSSNode);
        }
        String string = cSSNode.jjtGetChild(0).getText();
        CSSExpression cSSExpression = this._createExpression(cSSNode.jjtGetChild(1));
        boolean bl = false;
        if (n == 3) {
            object = cSSNode.jjtGetChild(2);
            if (ECSSNodeType.IMPORTANT.isNode((CSSNode)object, this.m_eVersion)) {
                bl = true;
            } else {
                s_aLogger.warn("Expected an " + ECSSNodeType.IMPORTANT.getNodeName(this.m_eVersion) + " token but got a " + ECSSNodeType.getNodeName((CSSNode)object, this.m_eVersion));
            }
        }
        object = new CSSDeclaration(string, cSSExpression, bl);
        ((CSSDeclaration)object).setSourceLocation(cSSNode.getSourceLocation());
        return object;
    }

    @Nonnull
    private CSSStyleRule _createStyleRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.STYLERULE);
        CSSStyleRule cSSStyleRule = new CSSStyleRule();
        cSSStyleRule.setSourceLocation(cSSNode.getSourceLocation());
        boolean bl = true;
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.SELECTOR.isNode(cSSNode2, this.m_eVersion)) {
                if (!bl) {
                    s_aLogger.error("Found a selector after a declaration!");
                }
                cSSStyleRule.addSelector(this._createSelector(cSSNode2));
                continue;
            }
            bl = false;
            if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2, this.m_eVersion)) {
                int n = cSSNode2.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    cSSStyleRule.addDeclaration(this._createDeclaration(cSSNode2.jjtGetChild(i)));
                }
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSStyleRule;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSPageRule _createPageRule(@Nonnull CSSNode cSSNode) {
        Object object;
        this._expectNodeType(cSSNode, ECSSNodeType.PAGERULE);
        int n = cSSNode.jjtGetNumChildren();
        String string = null;
        int n2 = 0;
        if (n > 0 && ECSSNodeType.PSEUDOPAGE.isNode((CSSNode)(object = cSSNode.jjtGetChild(0)), this.m_eVersion)) {
            string = ((CSSNode)object).getText();
            ++n2;
        }
        object = new CSSPageRule(string);
        ((CSSPageRule)object).setSourceLocation(cSSNode.getSourceLocation());
        for (int i = n2; i < n; ++i) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2, this.m_eVersion)) {
                int n3 = cSSNode2.jjtGetNumChildren();
                for (int j = 0; j < n3; ++j) {
                    ((CSSPageRule)object).addDeclaration(this._createDeclaration(cSSNode2.jjtGetChild(j)));
                }
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported page rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return object;
    }

    @Nonnull
    private CSSMediaRule _createMediaRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIARULE);
        CSSMediaRule cSSMediaRule = new CSSMediaRule();
        cSSMediaRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.MEDIALIST.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    cSSMediaRule.addMediaQuery(this._createMediaQuery(cSSNode3));
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createStyleRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported media-rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSMediaRule;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSMediaQuery _createMediaQuery(@Nonnull CSSNode cSSNode) {
        Object object;
        Object object2;
        if (ECSSNodeType.MEDIUM.isNode(cSSNode, this.m_eVersion)) {
            String string = cSSNode.getText();
            if (ECSSMedium.getFromNameOrNull(string) == null) {
                s_aLogger.warn("CSS " + this.m_eVersion.getVersionString() + " Media query uses unknown medium '" + string + "'");
            }
            CSSMediaQuery cSSMediaQuery = new CSSMediaQuery(CSSMediaQuery.EModifier.NONE, string);
            cSSMediaQuery.setSourceLocation(cSSNode.getSourceLocation());
            return cSSMediaQuery;
        }
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIAQUERY);
        int n = cSSNode.jjtGetNumChildren();
        int n2 = 0;
        CSSMediaQuery.EModifier eModifier = CSSMediaQuery.EModifier.NONE;
        if (n > 0 && ECSSNodeType.MEDIAMODIFIER.isNode((CSSNode)(object2 = cSSNode.jjtGetChild(0)), this.m_eVersion)) {
            object = ((CSSNode)object2).getText();
            if (object != null) {
                if ("not".equalsIgnoreCase((String)object)) {
                    eModifier = CSSMediaQuery.EModifier.NOT;
                } else if ("only".equalsIgnoreCase((String)object)) {
                    eModifier = CSSMediaQuery.EModifier.ONLY;
                } else {
                    s_aLogger.warn("Unsupported media modifier '" + (String)object + "' found!");
                }
            }
            ++n2;
        }
        object2 = null;
        if (n > n2 && ECSSNodeType.MEDIUM.isNode((CSSNode)(object = cSSNode.jjtGetChild(n2)), this.m_eVersion)) {
            object2 = ((CSSNode)object).getText();
            if (ECSSMedium.getFromNameOrNull((String)object2) == null) {
                s_aLogger.warn("CSS " + this.m_eVersion.getVersionString() + " media query uses unknown medium '" + (String)object2 + "'");
            }
            ++n2;
        }
        object = new CSSMediaQuery(eModifier, (String)object2);
        ((CSSMediaQuery)object).setSourceLocation(cSSNode.getSourceLocation());
        for (int i = n2; i < n; ++i) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.MEDIAEXPR.isNode(cSSNode2, this.m_eVersion)) {
                ((CSSMediaQuery)object).addMediaExpression(this._createMediaExpr(cSSNode2));
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported media query child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return object;
    }

    @Nonnull
    private CSSMediaExpression _createMediaExpr(@Nonnull CSSNode cSSNode) {
        CSSMediaExpression cSSMediaExpression;
        CSSNode cSSNode2;
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIAEXPR);
        int n = cSSNode.jjtGetNumChildren();
        if (n != 1 && n != 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount("Expected 1 or 2 children but got " + n + "!", cSSNode);
        }
        if (!ECSSNodeType.MEDIAFEATURE.isNode(cSSNode2 = cSSNode.jjtGetChild(0), this.m_eVersion)) {
            throw new IllegalStateException("Expected a media feature but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        String string = cSSNode2.getText();
        if (ECSSMediaExpressionFeature.getFromNameOrNull(string) == null) {
            s_aLogger.warn("Media expression uses unsupported feature '" + string + "'");
        }
        if (n == 1) {
            cSSMediaExpression = new CSSMediaExpression(string);
        } else {
            CSSNode cSSNode3 = cSSNode.jjtGetChild(1);
            cSSMediaExpression = new CSSMediaExpression(string, this._createExpression(cSSNode3));
        }
        cSSMediaExpression.setSourceLocation(cSSNode.getSourceLocation());
        return cSSMediaExpression;
    }

    @Nonnull
    private CSSFontFaceRule _createFontFaceRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.FONTFACERULE);
        CSSFontFaceRule cSSFontFaceRule = new CSSFontFaceRule();
        cSSFontFaceRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2, this.m_eVersion)) {
                int n = cSSNode2.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    cSSFontFaceRule.addDeclaration(this._createDeclaration(cSSNode2.jjtGetChild(i)));
                }
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported font-face rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSFontFaceRule;
    }

    @Nonnull
    private CSSKeyframesRule _createKeyframesRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.KEYFRAMESRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n == 0) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount("Expected at least 1 child but got " + n + "!", cSSNode);
        }
        String string = cSSNode.getText();
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        this._expectNodeType(cSSNode2, ECSSNodeType.KEYFRAMESIDENTIFIER);
        String string2 = cSSNode2.getText();
        CSSKeyframesRule cSSKeyframesRule = new CSSKeyframesRule(string, string2);
        cSSKeyframesRule.setSourceLocation(cSSNode.getSourceLocation());
        CSSKeyframesBlock cSSKeyframesBlock = null;
        for (int i = 1; i < n; ++i) {
            CSSNode cSSNode3 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.KEYFRAMESSELECTOR.isNode(cSSNode3, this.m_eVersion)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (CSSNode cSSNode4 : cSSNode3) {
                    this._expectNodeType(cSSNode4, ECSSNodeType.SINGLEKEYFRAMESELECTOR);
                    arrayList.add(cSSNode4.getText());
                }
                cSSKeyframesBlock = new CSSKeyframesBlock(arrayList);
                cSSKeyframesBlock.setSourceLocation(cSSNode3.getSourceLocation());
                cSSKeyframesRule.addBlock(cSSKeyframesBlock);
                continue;
            }
            if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode3, this.m_eVersion)) {
                if (cSSKeyframesBlock == null) {
                    throw new IllegalStateException("No keyframes block present!");
                }
                int n2 = cSSNode3.jjtGetNumChildren();
                for (int j = 0; j < n2; ++j) {
                    cSSKeyframesBlock.addDeclaration(this._createDeclaration(cSSNode3.jjtGetChild(j)));
                }
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(cSSNode3, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported keyframes rule child: " + ECSSNodeType.getNodeName(cSSNode3, this.m_eVersion));
        }
        return cSSKeyframesRule;
    }

    @Nonnull
    private CSSViewportRule _createViewportRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.VIEWPORTRULE);
        String string = cSSNode.getText();
        CSSViewportRule cSSViewportRule = new CSSViewportRule(string);
        cSSViewportRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2, this.m_eVersion)) {
                int n = cSSNode2.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    cSSViewportRule.addDeclaration(this._createDeclaration(cSSNode2.jjtGetChild(i)));
                }
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported viewport rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSViewportRule;
    }

    @Nonnull
    private CSSNamespaceRule _createNamespaceRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.NAMESPACERULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1 || n > 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount("Expected at least 1 child and at last 2 children but got " + n + "!", cSSNode);
        }
        String string = null;
        int n2 = 0;
        if (ECSSNodeType.NAMESPACERULEPREFIX.isNode(cSSNode.jjtGetChild(0), this.m_eVersion)) {
            string = cSSNode.jjtGetChild(0).getText();
            ++n2;
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
        this._expectNodeType(cSSNode2, ECSSNodeType.NAMESPACERULEURL);
        CSSNamespaceRule cSSNamespaceRule = new CSSNamespaceRule(string, cSSNode2.getText());
        cSSNamespaceRule.setSourceLocation(cSSNode.getSourceLocation());
        return cSSNamespaceRule;
    }

    @Nonnull
    public CascadingStyleSheet createCascadingStyleSheetFromNode(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.ROOT);
        CascadingStyleSheet cascadingStyleSheet = new CascadingStyleSheet();
        cascadingStyleSheet.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.CHARSET.isNode(cSSNode2, this.m_eVersion)) continue;
            if (ECSSNodeType.IMPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addImportRule(this._createImportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.NAMESPACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addNamespaceRule(this._createNamespaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createStyleRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.UNKNOWNRULE.isNode(cSSNode2, this.m_eVersion)) {
                s_aLogger.warn("Unknown rule object is currently ignored: " + cSSNode2);
                continue;
            }
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cascadingStyleSheet;
    }

    @Nonnull
    public CSSDeclarationList createDeclarationListFromNode(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.STYLEDECLARATION);
        CSSDeclarationList cSSDeclarationList = new CSSDeclarationList();
        cSSDeclarationList.setSourceLocation(cSSNode.getSourceLocation());
        int n = cSSNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            cSSDeclarationList.addDeclaration(this._createDeclaration(cSSNode.jjtGetChild(i)));
        }
        return cSSDeclarationList;
    }
}

