/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.parser;

import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.css.parser.TokenMgrError;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ParseUtils {
    private ParseUtils() {
    }

    @Nonnull
    private static String _trimBy(@Nonnull CharSequence charSequence, int n, int n2) {
        return ((Object)charSequence).toString().substring(n, charSequence.length() - n2);
    }

    @Nullable
    public static String extractStringValue(@Nullable String string) {
        if (StringHelper.hasNoText((String)string) || string.length() < 2) {
            return string;
        }
        char c = string.charAt(0);
        if ((c == '\"' || c == '\'') && StringHelper.getLastChar((CharSequence)string) == c) {
            return ParseUtils._trimBy(string, 1, 1);
        }
        return string;
    }

    @Nonnull
    public static String trimUrl(@Nonnull CharSequence charSequence) {
        String string = ParseUtils._trimBy(charSequence, 4, 1).trim();
        return ParseUtils.extractStringValue(string);
    }

    @Nonnull
    public static String splitNumber(@Nonnull StringBuilder stringBuilder) {
        Matcher matcher = RegExHelper.getMatcher((String)"^([0-9]*\\.[0-9]+|[0-9]+).*$", (String)stringBuilder.toString());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    @Nonnull
    public static String validateIdentifier(@Nonnull StringBuilder stringBuilder) {
        char c;
        int n = stringBuilder.length();
        char c2 = stringBuilder.charAt(0);
        char c3 = c = n <= 1 ? (char)'\u0000' : stringBuilder.charAt(1);
        if (c2 == '-' || c2 == '$' || c2 == '*') {
            if (n > 1 && Character.isDigit(c)) {
                throw new TokenMgrError("Identifier may not start with a hyphen and a digit: " + stringBuilder, 0);
            }
        } else if (Character.isDigit(c2)) {
            throw new TokenMgrError("Identifier may not start with a digit: " + stringBuilder, 0);
        }
        if (n > 1 && c2 == '-' && c == '-') {
            throw new TokenMgrError("Identifier may not start with two hyphens: " + stringBuilder, 0);
        }
        return stringBuilder.toString();
    }
}

