/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.string.StringParser;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.property.CSSPropertyFree;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.ICSSProperty;
import com.phloc.css.propertyvalue.CSSValue;
import com.phloc.css.propertyvalue.CSSValueList;
import com.phloc.css.propertyvalue.CSSValueMultiProperty;
import com.phloc.css.propertyvalue.CSSValueMultiValue;
import com.phloc.css.propertyvalue.ICSSValue;
import com.phloc.css.utils.ICSSNamedColor;
import javax.annotation.Nonnull;

public abstract class AbstractCSSProperty
implements ICSSProperty {
    private final ECSSProperty m_eProp;

    protected AbstractCSSProperty(@Nonnull ECSSProperty eCSSProperty) {
        if (eCSSProperty == null) {
            throw new NullPointerException("prop");
        }
        this.m_eProp = eCSSProperty;
    }

    @Override
    @Nonnull
    public final ECSSVersion getMinimumCSSVersion() {
        return this.m_eProp.getMinimumCSSVersion();
    }

    @Override
    @Nonnull
    public final ECSSProperty getProp() {
        return this.m_eProp;
    }

    @Nonnull
    private ICSSValue _newValue(@Nonnull String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("value");
        }
        switch (this.m_eProp) {
            case DISPLAY: {
                if (!string.equals("inline-block")) break;
                return new CSSValueMultiValue(this, new String[]{"-moz-inline-block", string}, bl);
            }
            case OPACITY: {
                double d = StringParser.parseDouble((String)string, (double)Double.NaN);
                if (Double.isNaN(d)) break;
                int n = (int)(d * 100.0);
                return new CSSValueList(new ICSSProperty[]{new CSSPropertyFree(ECSSProperty._MS_FILTER), new CSSPropertyFree(ECSSProperty.FILTER), this.getClone(ECSSProperty._MOZ_OPACITY), this.getClone(ECSSProperty._WEBKIT_OPACITY), this}, new String[]{"\"progid:DXImageTransform.Microsoft.Alpha(Opacity=" + n + ")\"", "alpha(opacity=" + n + ")", string, string, string}, bl);
            }
            case BORDER_RADIUS: {
                return new CSSValueMultiProperty(new ICSSProperty[]{this, this.getClone(ECSSProperty._MOZ_BORDER_RADIUS), this.getClone(ECSSProperty._WEBKIT_BORDER_RADIUS), this.getClone(ECSSProperty._KHTML_BORDER_RADIUS)}, string, bl);
            }
            case BORDER_TOP_LEFT_RADIUS: {
                return new CSSValueMultiProperty(new ICSSProperty[]{this, this.getClone(ECSSProperty._MOZ_BORDER_RADIUS_TOPLEFT), this.getClone(ECSSProperty._WEBKIT_BORDER_TOP_LEFT_RADIUS), this.getClone(ECSSProperty._KHTML_BORDER_TOP_LEFT_RADIUS)}, string, bl);
            }
            case BORDER_TOP_RIGHT_RADIUS: {
                return new CSSValueMultiProperty(new ICSSProperty[]{this, this.getClone(ECSSProperty._MOZ_BORDER_RADIUS_TOPRIGHT), this.getClone(ECSSProperty._WEBKIT_BORDER_TOP_RIGHT_RADIUS), this.getClone(ECSSProperty._KHTML_BORDER_TOP_RIGHT_RADIUS)}, string, bl);
            }
            case BORDER_BOTTOM_LEFT_RADIUS: {
                return new CSSValueMultiProperty(new ICSSProperty[]{this, this.getClone(ECSSProperty._MOZ_BORDER_RADIUS_BOTTOMLEFT), this.getClone(ECSSProperty._WEBKIT_BORDER_BOTTOM_LEFT_RADIUS), this.getClone(ECSSProperty._KHTML_BORDER_BOTTOM_LEFT_RADIUS)}, string, bl);
            }
            case BORDER_BOTTOM_RIGHT_RADIUS: {
                return new CSSValueMultiProperty(new ICSSProperty[]{this, this.getClone(ECSSProperty._MOZ_BORDER_RADIUS_BOTTOMRIGHT), this.getClone(ECSSProperty._WEBKIT_BORDER_BOTTOM_RIGHT_RADIUS), this.getClone(ECSSProperty._KHTML_BORDER_BOTTOM_RIGHT_RADIUS)}, string, bl);
            }
        }
        return new CSSValue(this, string, bl);
    }

    @Override
    @Nonnull
    public final ICSSValue newValue(@Nonnull String string) {
        return this._newValue(string, false);
    }

    @Override
    @Nonnull
    public final ICSSValue newImportantValue(@Nonnull String string) {
        return this._newValue(string, true);
    }

    @Override
    @Nonnull
    public final ICSSValue newValue(@Nonnull ICSSNamedColor iCSSNamedColor) {
        return this.newValue(iCSSNamedColor.getName());
    }

    @Override
    @Nonnull
    public final ICSSValue newImportantValue(@Nonnull ICSSNamedColor iCSSNamedColor) {
        return this.newImportantValue(iCSSNamedColor.getName());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("prop", (Enum)this.m_eProp).toString();
    }
}

