/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.AbstractCSSProperty;
import com.phloc.css.property.ECSSProperty;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSPropertyEnum
extends AbstractCSSProperty {
    protected final Set<String> m_aEnumValues;

    public CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty, String ... stringArray) {
        super(eCSSProperty);
        this.m_aEnumValues = new HashSet<String>(stringArray.length);
        for (String string : stringArray) {
            if (StringHelper.hasNoText((String)string)) {
                throw new IllegalArgumentException("At least one enumeration value is empty");
            }
            this.m_aEnumValues.add(string);
        }
        if (this.m_aEnumValues.isEmpty()) {
            throw new IllegalArgumentException("At least one enumeration value needs to be passed!");
        }
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty);
        this.m_aEnumValues = new HashSet<String>();
        for (String string : iterable) {
            if (StringHelper.hasNoText((String)string)) {
                throw new IllegalArgumentException("At least one enumeration value is empty");
            }
            this.m_aEnumValues.add(string);
        }
        if (this.m_aEnumValues.isEmpty()) {
            throw new IllegalArgumentException("At least one enumeration value needs to be passed!");
        }
    }

    private CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty, @Nonnull @Nonempty Set<String> set) {
        super(eCSSProperty);
        this.m_aEnumValues = new HashSet<String>(set);
    }

    @Override
    public boolean isValidValue(@Nullable String string) {
        return this.m_aEnumValues.contains(string);
    }

    @Override
    @Nonnull
    public CSSPropertyEnum getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnum(eCSSProperty, this.m_aEnumValues);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("enumValues", this.m_aEnumValues).toString();
    }
}

