/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.CSSPropertyEnum;
import com.phloc.css.property.ECSSProperty;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSPropertyEnums
extends CSSPropertyEnum {
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, stringArray);
        if (n < 0) {
            throw new IllegalArgumentException("minNumbers: " + n);
        }
        if (n2 < 0 || n2 < n) {
            throw new IllegalArgumentException("maxNumbers: " + n2);
        }
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, iterable);
        if (n < 0) {
            throw new IllegalArgumentException("minNumbers: " + n);
        }
        if (n2 < 0 || n2 < n) {
            throw new IllegalArgumentException("maxNumbers: " + n2);
        }
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    @Override
    public boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)string.trim(), (String)"\\s+");
        if (stringArray.length < this.m_nMinNumbers || stringArray.length > this.m_nMaxNumbers) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (super.isValidValue(stringArray[i].trim())) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnums getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnums(eCSSProperty, this.m_nMinNumbers, this.m_nMaxNumbers, this.m_aEnumValues);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).toString();
    }
}

