/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.utils;

import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.StringParser;
import com.phloc.css.ECSSUnit;
import com.phloc.css.propertyvalue.CSSSimpleValueWithUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSNumberHelper {
    private CSSNumberHelper() {
    }

    @Nullable
    public static ECSSUnit getMatchingUnitInclPercentage(@Nonnull String string) {
        for (ECSSUnit eCSSUnit : ECSSUnit.values()) {
            if (!string.endsWith(eCSSUnit.getName())) continue;
            return eCSSUnit;
        }
        return null;
    }

    @Nullable
    public static ECSSUnit getMatchingUnitExclPercentage(@Nonnull String string) {
        for (ECSSUnit eCSSUnit : ECSSUnit.values()) {
            if (eCSSUnit == ECSSUnit.PERCENTAGE || !string.endsWith(eCSSUnit.getName())) continue;
            return eCSSUnit;
        }
        return null;
    }

    public static boolean isNumberValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.hasText((String)string2) && StringParser.isDouble((String)string2);
    }

    public static boolean isValueWithUnit(@Nullable String string) {
        return CSSNumberHelper.getValueWithUnit(string) != null;
    }

    public static boolean isValueWithUnit(@Nullable String string, boolean bl) {
        return CSSNumberHelper.getValueWithUnit(string, bl) != null;
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String string) {
        return CSSNumberHelper.getValueWithUnit(string, true);
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String string, boolean bl) {
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasText((String)string2)) {
            Double d;
            ECSSUnit eCSSUnit;
            if (string2.equals("0")) {
                return new CSSSimpleValueWithUnit(0.0, ECSSUnit.PX);
            }
            ECSSUnit eCSSUnit2 = eCSSUnit = bl ? CSSNumberHelper.getMatchingUnitInclPercentage(string2) : CSSNumberHelper.getMatchingUnitExclPercentage(string2);
            if (eCSSUnit != null && (d = StringParser.parseDoubleObj((String)(string2 = string2.substring(0, string2.length() - eCSSUnit.getName().length()).trim()))) != null) {
                return new CSSSimpleValueWithUnit(d, eCSSUnit);
            }
        }
        return null;
    }
}

