/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.utils;

import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.css.decl.CSSRect;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSRectHelper {
    @RegEx
    private static final String PATTERN_PART_VALUE = "([0-9]+(?:[a-zA-Z]+|%)?|auto)";
    @RegEx
    private static final String PATTERN_CURRENT_SYNTAX = "^rect\\s*\\(\\s*([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s*,\\s*([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s*,\\s*([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s*,\\s*([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s*\\)$";
    @RegEx
    private static final String PATTERN_OLD_SYNTAX = "^rect\\s*\\(\\s*([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s+([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s+([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s+([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s*\\)$";

    private CSSRectHelper() {
    }

    public static boolean isRectValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasText((String)string2)) {
            if (RegExHelper.stringMatchesPattern((String)PATTERN_CURRENT_SYNTAX, (String)string2)) {
                return true;
            }
            if (RegExHelper.stringMatchesPattern((String)PATTERN_OLD_SYNTAX, (String)string2)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static String[] getRectValues(@Nullable String string) {
        String[] stringArray = null;
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasText((String)string2) && (stringArray = RegExHelper.getAllMatchingGroupValues((String)PATTERN_CURRENT_SYNTAX, (String)string2)) == null) {
            stringArray = RegExHelper.getAllMatchingGroupValues((String)PATTERN_OLD_SYNTAX, (String)string2);
        }
        return stringArray;
    }

    @Nullable
    public static CSSRect getAsRect(@Nullable String string) {
        String[] stringArray = CSSRectHelper.getRectValues(string);
        return stringArray == null ? null : new CSSRect(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
    }
}

