/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.utils;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.url.ISimpleURL;
import com.phloc.css.parser.ParseUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSURLHelper {
    public static final boolean DEFAULT_QUOTE_URLS = false;

    private CSSURLHelper() {
    }

    public static boolean isURLValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.getLength((CharSequence)string2) > 5 && string2.startsWith("url(") && string2.endsWith(")");
    }

    @Nullable
    public static String getURLValue(@Nullable String string) {
        if (CSSURLHelper.isURLValue(string)) {
            String string2 = string.trim();
            String string3 = string2.substring("url(".length(), string2.length() - 1);
            return ParseUtils.extractStringValue(string3);
        }
        return null;
    }

    @Nonnull
    @Nonempty
    public static String getAsCSSURL(@Nonnull ISimpleURL iSimpleURL, boolean bl) {
        if (iSimpleURL == null) {
            throw new NullPointerException("URL");
        }
        return CSSURLHelper.getAsCSSURL(iSimpleURL.getAsString(), bl);
    }

    @Nonnull
    @Nonempty
    public static String getAsCSSURL(@Nonnull @Nonempty String string, boolean bl) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("passed URL is empty!");
        }
        if (bl) {
            return "url('" + string + "')";
        }
        return "url(" + string + ')';
    }
}

