/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.writer;

import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.io.streams.NonBlockingStringWriter;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclarationList;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSNamespaceRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.writer.CSSWriterSettings;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSWriter {
    public static final boolean DEFAULT_OPTIMIZED_OUTPUT = false;
    private final CSSWriterSettings m_aSettings;
    private boolean m_bWriteHeaderText;
    private String m_sHeaderText = "THIS FILE IS GENERATED - DO NOT EDIT";
    private String m_sContentCharset;

    public CSSWriter(@Nonnull ECSSVersion eCSSVersion) {
        this(eCSSVersion, false);
    }

    public CSSWriter(@Nonnull ECSSVersion eCSSVersion, boolean bl) {
        this(new CSSWriterSettings(eCSSVersion, bl));
    }

    public CSSWriter(@Nonnull CSSWriterSettings cSSWriterSettings) {
        if (cSSWriterSettings == null) {
            throw new NullPointerException("settings");
        }
        this.m_aSettings = cSSWriterSettings;
        this.m_bWriteHeaderText = !cSSWriterSettings.isOptimizedOutput();
    }

    public boolean isWriteHeaderText() {
        return this.m_bWriteHeaderText;
    }

    @Nonnull
    public CSSWriter setWriteHeaderText(boolean bl) {
        this.m_bWriteHeaderText = bl;
        return this;
    }

    @Nullable
    public String getHeaderText() {
        return this.m_sHeaderText;
    }

    @Nonnull
    public CSSWriter setHeaderText(@Nullable String string) {
        this.m_sHeaderText = string;
        return this;
    }

    @Nullable
    public String getContentCharset() {
        return this.m_sContentCharset;
    }

    @Nonnull
    public CSSWriter setContentCharset(@Nullable String string) {
        this.m_sContentCharset = string;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject(reason="Design")
    public CSSWriterSettings getSettings() {
        return this.m_aSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCSS(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull @WillClose Writer writer) throws IOException {
        if (cascadingStyleSheet == null) {
            throw new NullPointerException("css");
        }
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        try {
            Iterator<ICSSTopLevelRule> iterator;
            Object object;
            List<CSSImportRule> list22;
            boolean bl = this.m_aSettings.isOptimizedOutput();
            if (this.m_bWriteHeaderText && StringHelper.hasText((String)this.m_sHeaderText)) {
                writer.write("/*\n");
                for (List<CSSImportRule> list22 : StringHelper.getExploded((String)"\n", (String)this.m_sHeaderText)) {
                    writer.write(" * " + (String)((Object)list22) + "\n");
                }
                writer.write(" */\n");
            }
            if (StringHelper.hasText((String)this.m_sContentCharset)) {
                writer.write("@charset \"" + this.m_sContentCharset + "\"\n");
                if (!bl) {
                    writer.write(10);
                }
            }
            int n = 0;
            list22 = cascadingStyleSheet.getAllImportRules();
            if (!list22.isEmpty()) {
                object = list22.iterator();
                while (object.hasNext()) {
                    iterator = (CSSImportRule)object.next();
                    writer.write(((CSSImportRule)((Object)iterator)).getAsCSSString(this.m_aSettings, 0));
                    ++n;
                }
            }
            if (!(object = cascadingStyleSheet.getAllNamespaceRules()).isEmpty()) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    CSSNamespaceRule iCSSWriteable = (CSSNamespaceRule)((Object)iterator.next());
                    writer.write(iCSSWriteable.getAsCSSString(this.m_aSettings, 0));
                    ++n;
                }
            }
            for (ICSSTopLevelRule iCSSTopLevelRule : cascadingStyleSheet.getAllRules()) {
                String string = iCSSTopLevelRule.getAsCSSString(this.m_aSettings, 0);
                if (!StringHelper.hasText((String)string)) continue;
                if (!bl && n > 0) {
                    writer.write(10);
                }
                writer.write(string);
                ++n;
            }
        }
        finally {
            StreamUtils.close((Closeable)writer);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull CascadingStyleSheet cascadingStyleSheet) throws IOException {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        this.writeCSS(cascadingStyleSheet, (Writer)nonBlockingStringWriter);
        return nonBlockingStringWriter.getAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCSS(@Nonnull CSSDeclarationList cSSDeclarationList, @Nonnull @WillClose Writer writer) throws IOException {
        if (cSSDeclarationList == null) {
            throw new NullPointerException("css");
        }
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        try {
            writer.write(cSSDeclarationList.getAsCSSString(this.m_aSettings, 0));
        }
        finally {
            StreamUtils.close((Closeable)writer);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull CSSDeclarationList cSSDeclarationList) throws IOException {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        this.writeCSS(cSSDeclarationList, (Writer)nonBlockingStringWriter);
        return nonBlockingStringWriter.getAsString();
    }
}

