$(document).ready(function()
	{
		// Safari is no good.
		if ($.browser.safari)
		{
			// Set specific variable to represent all iframe tags.
			var iFrames = document.getElementsByTagName('iframe');

			// Resize heights.
			function iResize()
			{
				for (var i = 0; i < iFrames.length; i++)
				{
					iFrames[i].style.height = iFrames[i].contentWindow.document.body.offsetHeight + 'px';
				}
			}

			// Start timer when loaded.
			$('iframe').load(function()
				{
					setTimeout(iResize, 0);
				}
			);

			// For Safari to realize iframes loaded.
			for (var i = 0; i < iFrames.length; i++)
			{
				var iSource = iFrames[i].src;
				iFrames[i].src = '';
				iFrames[i].src = iSource;
			}
		}
		else
		{
			// For other good browsers.
			$('iframe').load(function()
				{
					this.style.height = this.contentWindow.document.body.offsetHeight + 'px';
				}
			);
		}
	}
);