<?php
 require_once(MINIXML_CLASSDIR . "/treecomp.inc.php"); require_once(MINIXML_CLASSDIR . "/node.inc.php"); class MiniXMLElement extends MiniXMLTreeComponent { var $xname; var $xattributes; var $xchildren; var $xnumChildren; var $xnumElementChildren; var $iselement; var $xavoidLoops = MINIXML_AVOIDLOOPS; function MiniXMLElement ($name=NULL) { $this->MiniXMLTreeComponent(); $this->iselement = 1; $this->xname = NULL; $this->xattributes = array(); $this->xchildren = array(); $this->xnumChildren = 0; $this->xnumElementChildren = 0; if ($name) { $this->name($name); } else { return _MiniXMLError("MiniXMLElement Constructor: must pass a name to constructor"); } } function name ($setTo=NULL) { if (! is_null($setTo)) { if (! is_string($setTo)) { return _MiniXMLError("MiniXMLElement::name() Must pass a STRING to method to set name"); } $this->xname = $setTo; } return $this->xname; } function attribute ($name, $primValue=NULL, $altValue=NULL) { $value = (is_null($primValue) ? $altValue : $primValue ); if (MINIXML_UPPERCASEATTRIBUTES > 0) { $name = strtoupper($name); } elseif (MINIXML_LOWERCASEATTRIBUTES > 0) { $name = strtolower($name); } if (! is_null($value)) { $this->xattributes[$name] = $value; } if (! is_null($this->xattributes[$name])) { return $this->xattributes[$name]; } else { return NULL; } } function text ($setToPrimary = NULL, $setToAlternate=NULL) { $setTo = ($setToPrimary ? $setToPrimary : $setToAlternate); if (! is_null($setTo)) { $this->createNode($setTo); } $retString = ''; for($i=0; $i< $this->xnumChildren; $i++) { if ($this->isNode($this->xchildren[$i])) { $nodeTxt = $this->xchildren[$i]->getValue(); if (! is_null($nodeTxt)) { $retString .= "$nodeTxt "; } } } return $retString; } function numeric ($setToPrimary = NULL, $setToAlternate=NULL) { $setTo = (is_null($setToPrimary) ? $setToAlternate : $setToPrimary); if (! is_null($setTo)) { $this->createNode($setTo); } } function & comment ($contents) { $appendedComment =& $this->appendChild(new MiniXMLElementComment()); $appendedComment->text($contents); return $appendedComment; } function & docType ($definition) { $appendedElement =& $this->appendChild(new MiniXMLElementDocType($definition)); return $appendedElement; } function & entity ($name,$value) { $appendedEl =& $this->appendChild(new MiniXMLElementEntity($name, $value)); return $appendedEl; } function & cdata ($contents) { $appendedChild =& $this->appendChild(new MiniXMLElementCData($contents)); return $appendedChild; } function getValue ($seperator=' ') { $retStr = ''; $valArray = array(); for($i=0; $i < $this->xnumChildren; $i++) { $value = $this->xchildren[$i]->getValue(); if (! is_null($value)) { array_push($valArray, $value); } } if (count($valArray)) { $retStr = implode($seperator, $valArray); } return $retStr; } function &getElement ($name) { if (MINIXML_DEBUG > 0) { $elname = $this->name(); _MiniXMLLog("MiniXMLElement::getElement() called for $name on $elname."); } if (is_null($name)) { return _MiniXMLError("MiniXMLElement::getElement() Must Pass Element name."); } if (! $this->xnumChildren ) { return NULL; } for ($i = 0; $i < $this->xnumChildren; $i++) { $childname = $this->xchildren[$i]->name(); if ($childname) { if (MINIXML_CASESENSITIVE > 0) { if (strcmp($name, $childname) == 0) { return $this->xchildren[$i]; } } else { if (strcasecmp($name, $childname) == 0) { return $this->xchildren[$i]; } } } } for ($i = 0; $i < $this->xnumChildren; $i++) { $theelement =& $this->xchildren[$i]->getElement($name); if ($theelement) { if (MINIXML_DEBUG > 0) { _MiniXMLLog("MiniXMLElement::getElement() returning element $theelement"); } return $theelement; } } return _MiniXMLReturnNullByRef(); } function &getElementByPath($path) { $names = split ("/", $path); $element = $this; foreach ($names as $elementName) { if ($element && $elementName) { $element =& $element->getElement($elementName); } } return $element; } function numChildren ($named=NULL) { if (is_null($named)) { return $this->xnumElementChildren; } $allkids =& $this->getAllChildren($named); return count($allkids); } function &getAllChildren ($name=NULL) { $retArray = array(); $count = 0; if (is_null($name)) { for($i=0; $i < $this->xnumChildren; $i++) { if (method_exists($this->xchildren[$i], 'MiniXMLElement')) { $retArray[$count++] =& $this->xchildren[$i]; } } } else { for($i=0; $i < $this->xnumChildren; $i++) { if (method_exists($this->xchildren[$i], 'MiniXMLElement')) { if (MINIXML_CASESENSITIVE > 0) { if ($this->xchildren[$i]->name() == $name) { $retArray[$count++] =& $this->xchildren[$i]; } } else { if (strcasecmp($this->xchildren[$i]->name(), $name) == 0) { $retArray[$count++] =& $this->xchildren[$i]; } } } } } return $retArray; } function &insertChild (&$child, $idx=0) { if (! $this->_validateChild($child)) { return; } if ($this->xavoidLoops || (MINIXML_AUTOSETPARENT > 0) ) { if ($this->xparent == $child) { $cname = $child->name(); return _MiniXMLError("MiniXMLElement::insertChild() Tryng to append parent $cname as child of " . $this->xname ); } $child->parent($this); } $nextIdx = $this->xnumChildren; $lastIdx = $nextIdx - 1; if ($idx > $lastIdx) { if ($idx > $nextIdx) { $idx = $lastIdx + 1; } $this->xchildren[$idx] =& $child; $this->xnumChildren++; if ($this->isElement($child)) { $this->xnumElementChildren++; } } elseif ($idx >= 0) { $removed = array_splice($this->xchildren, $idx); array_push($this->xchildren, $child); $numRemoved = count($removed); for($i=0; $i<$numRemoved; $i++) { array_push($this->xchildren, $removed[$i]); } $this->xnumChildren++; if ($this->isElement($child)) { $this->xnumElementChildren++; } } else { $revIdx = (-1 * $idx) % $this->xnumChildren; $newIdx = $this->xnumChildren - $revIdx; if ($newIdx < 0) { return _MiniXMLError("Element::insertChild() Ended up with a negative index? ($newIdx)"); } return $this->insertChild($child, $newIdx); } return $child; } function &appendChild (&$child) { if (! $this->_validateChild($child)) { _MiniXMLLog("MiniXMLElement::appendChild() Could not validate child, aborting append"); return _MiniXMLReturnNullByRef(); } if ($this->xavoidLoops || (MINIXML_AUTOSETPARENT > 0) ) { if ($this->xparent == $child) { $cname = $child->name(); return _MiniXMLError("MiniXMLElement::appendChild() Tryng to append parent $cname as child of " . $this->xname ); } $child->parent($this); } $this->xnumElementChildren++; $idx = $this->xnumChildren++; $this->xchildren[$idx] =& $child; return $this->xchildren[$idx]; } function &prependChild ($child) { if (! $this->_validateChild($child)) { _MiniXMLLog("MiniXMLElement::prependChild - Could not validate child, aborting."); return _MiniXMLReturnNullByRef(); } if ($this->xavoidLoops || (MINIXML_AUTOSETPARENT > 0) ) { if ($this->xparent == $child) { $cname = $child->name(); return _MiniXMLError("MiniXMLElement::prependChild() Tryng to append parent $cname as child of " . $this->xname ); } $child->parent($this); } $this->xnumElementChildren++; $idx = $this->xnumChildren++; array_unshift($this->xchildren, $child); return $this->xchildren[0]; } function _validateChild (&$child) { if (is_null($child)) { return _MiniXMLError("MiniXMLElement::_validateChild() need to pass a non-NULL MiniXMLElement child."); } if (!$child->iselement) { return _MiniXMLError("MiniXMLElement::_validateChild() must pass a MiniXMLElement object to _validateChild."); } $cname = $child->name(); if (is_null($cname)) { _MiniXMLLog("MiniXMLElement::_validateChild() children must be named"); return 0; } if ($child == $this) { _MiniXMLLog("MiniXMLElement::_validateChild() Trying to append self as own child!"); return 0; } elseif ( $this->xavoidLoops && $child->parent()) { _MiniXMLLog("MiniXMLElement::_validateChild() Trying to append a child ($cname) that already has a parent set " . "while avoidLoops is on - aborting"); return 0; } return 1; } function & createChild ($name, $value=NULL) { if (! $name) { return _MiniXMLError("MiniXMLElement::createChild() Must pass a NAME to createChild."); } if (! is_string($name)) { return _MiniXMLError("MiniXMLElement::createChild() Name of child must be a STRING"); } $appendedChild =& $this->appendChild(new MiniXMLElement($name)); if (! $appendedChild ) { _MiniXMLLog("MiniXMLElement::createChild() '$name' child NOT appended."); return NULL; } if (! is_null($value)) { if (is_numeric($value)) { $appendedChild->numeric($value); } elseif (is_string($value)) { $appendedChild->text($value); } } $appendedChild->avoidLoops($this->xavoidLoops); return $appendedChild; } function &removeChild (&$child) { if (! $this->xnumChildren) { if (MINIXML_DEBUG > 0) { _MiniXMLLog("Element::removeChild() called for element without any children.") ; } return NULL; } $foundChild = NULL; $idx = 0; while ($idx < $this->xnumChildren && ! $foundChild) { if ($this->xchildren[$idx] == $child) { $foundChild =& $this->xchildren[$idx]; } else { $idx++; } } if (! $foundChild) { if (MINIXML_DEBUG > 0) { _MiniXMLLog("Element::removeChild() No matching child found.") ; } return NULL; } array_splice($this->xchildren, $idx, 1); $this->xnumChildren--; if ($this->isElement($foundChild)) { $this->xnumElementChildren--; } unset ($foundChild->xparent) ; return $foundChild; } function &removeAllChildren () { $emptyArray = array(); if (! $this->xnumChildren) { return $emptyArray; } $retList =& $this->xchildren; $idx = 0; while ($idx < $this->xnumChildren) { unset ($retList[$idx++]->xparent); } unset($this->xchildren); $this->xchildren = array(); $this->xnumElementChildren = 0; $this->xnumChildren = 0; return $retList; } function & remove () { $parent =& $this->parent(); if (!$parent) { _MiniXMLLog("XML::Mini::Element::remove() called for element with no parent set.  Aborting."); return NULL; } $removed =& $parent->removeChild($this); return $removed; } function &parent (&$setParent) { if (! is_null($setParent)) { if (! $this->isElement($setParent)) { return _MiniXMLError("MiniXMLElement::parent(): Must pass an instance of MiniXMLElement to set."); } $this->xparent = $setParent; } return $this->xparent; } function avoidLoops ($setTo = NULL) { if (! is_null($setTo)) { $this->xavoidLoops = $setTo; } return $this->xavoidLoops; } function toString ($depth=0) { if ($depth == MINIXML_NOWHITESPACES) { return $this->toStringNoWhiteSpaces(); } else { return $this->toStringWithWhiteSpaces($depth); } } function toStringWithWhiteSpaces ($depth=0) { $attribString = ''; $elementName = $this->xname; $spaces = $this->_spaceStr($depth) ; $retString = "$spaces<$elementName"; foreach ($this->xattributes as $attrname => $attrvalue) { $attribString .= "$attrname=\"$attrvalue\" "; } if ($attribString) { $attribString = rtrim($attribString); $retString .= " $attribString"; } if (! $this->xnumChildren) { $retString .= " />\n"; return $retString; } $onlyTxtChild = 0; if ($this->xnumChildren == 1 && ! $this->xnumElementChildren) { $onlyTxtChild = 1; } if ($onlyTxtChild) { $nextDepth = 0; $retString .= ">"; } else { $nextDepth = $depth+1; $retString .= ">\n"; } for ($i=0; $i < $this->xnumChildren ; $i++) { if (method_exists($this->xchildren[$i], 'toStringWithWhiteSpaces') ) { $newStr = $this->xchildren[$i]->toStringWithWhiteSpaces($nextDepth); if (! is_null($newStr)) { if (! ( preg_match("/\n\$/", $newStr) || $onlyTxtChild) ) { $newStr .= "\n"; } $retString .= $newStr; } } else { _MiniXMLLog("Invalid child found in $elementName ". $this->xchildren[$i]->name() ); } } if ($onlyTxtChild) { $retString .= "</$elementName>\n"; } else { $retString .= "$spaces</$elementName>\n"; } return $retString; } function toStringNoWhiteSpaces () { $retString = ''; $attribString = ''; $elementName = $this->xname; foreach ($this->xattributes as $attrname => $attrvalue) { $attribString .= "$attrname=\"$attrvalue\" "; } $retString = "<$elementName"; if ($attribString) { $attribString = rtrim($attribString); $retString .= " $attribString"; } if (! $this->xnumChildren) { $retString .= " />"; return $retString; } $retString .= ">"; for ($i=0; $i < $this->xnumChildren ; $i++) { if (method_exists($this->xchildren[$i], 'toStringNoWhiteSpaces') ) { $newStr = $this->xchildren[$i]->toStringNoWhiteSpaces(); if (! is_null($newStr)) { $retString .= $newStr; } } else { _MiniXMLLog("Invalid child found in $elementName"); } } $retString .= "</$elementName>"; return $retString; } function & toStructure () { $retHash = array(); $contents = ""; $numAdded = 0; for($i=0; $i< $this->xnumChildren; $i++) { if ($this->isElement($this->xchildren[$i])) { $name = $this->xchildren[$i]->name(); if (array_key_exists($name, $retHash)) { if (! (is_array($retHash[$name]) && array_key_exists('_num', $retHash[$name])) ) { $retHash[$name] = array($retHash[$name], $this->xchildren[$i]->toStructure()); $retHash[$name]['_num'] = 2; } else { array_push($retHash[$name], $this->xchildren[$i]->toStructure() ); $retHash[$name]['_num']++; } } else { $retHash[$name] = $this->xchildren[$i]->toStructure(); } $numAdded++; } else { $contents .= $this->xchildren[$i]->getValue(); } } foreach ($this->xattributes as $attrname => $attrvalue) { $retHash["attr"][$attrname] = $attrvalue; $numAdded++; } if ($numAdded) { if (! empty($contents)) { $retHash['_content'] = $contents; } return $retHash; } else { return $contents; } } function isElement (&$testme) { if (is_null($testme)) { return 0; } return method_exists($testme, 'MiniXMLElement'); } function isNode (&$testme) { if (is_null($testme)) { return 0; } return method_exists($testme, 'MiniXMLNode'); } function & createNode (&$value, $escapeEntities=NULL) { return $this->appendNode(new MiniXMLNode($value, $escapeEntities)); } function &appendNode (&$node) { if (is_null($node)) { return _MiniXMLError("MiniXMLElement::appendNode() need to pass a non-NULL MiniXMLNode."); } if (! $node->isnode) { return _MiniXMLError("MiniXMLElement::appendNode() must pass a MiniXMLNode object to appendNode."); } if (MINIXML_AUTOSETPARENT) { if ($this->xparent == $node) { return _MiniXMLError("MiniXMLElement::appendnode() Tryng to append parent $cname as node of " . $this->xname ); } $node->parent($this); } $idx = $this->xnumChildren++; $this->xchildren[$idx] =& $node; return $this->xchildren[$idx]; } function __destruct() { for ($i = 0; $i < count($this->xchildren); ++$i) { unset($this->xchildren[$i]); } unset($this->xchildren); } } class MiniXMLElementComment extends MiniXMLElement { function MiniXMLElementComment ($name=NULL) { $this->MiniXMLElement('!--'); } function toString ($depth=0) { if ($depth == MINIXML_NOWHITESPACES) { return $this->toStringNoWhiteSpaces(); } else { return $this->toStringWithWhiteSpaces($depth); } } function toStringWithWhiteSpaces ($depth=0) { $spaces = $this->_spaceStr($depth) ; $retString = "$spaces<!-- \n"; if (! $this->xnumChildren) { $retString .= " -->\n"; return $retString; } $nextDepth = $depth+1; for ($i=0; $i < $this->xnumChildren ; $i++) { $retString .= $this->xchildren[$i]->toStringWithWhiteSpaces($nextDepth); } $retString .= "\n$spaces -->\n"; return $retString; } function toStringNoWhiteSpaces () { $retString = ''; $retString = "<!-- "; if (! $this->xnumChildren) { $retString .= " -->"; return $retString; } for ($i=0; $i < $this->xnumChildren ; $i++) { $retString .= $this->xchildren[$i]->toStringNoWhiteSpaces(); } $retString .= " -->"; return $retString; } } class MiniXMLElementCData extends MiniXMLElement { function MiniXMLElementCData ($contents) { $this->MiniXMLElement('CDATA'); if (! is_null($contents)) { $this->createNode($contents, 0) ; } } function toStringNoWhiteSpaces () { return $this->toString(MINIXML_NOWHITESPACES); } function toStringWithWhiteSpaces ($depth=0) { return $this->toString($depth); } function toString ($depth=0) { $spaces = ''; if ($depth != MINIXML_NOWHITESPACES) { $spaces = $this->_spaceStr($depth); } $retString = "$spaces<![CDATA[ "; if (! $this->xnumChildren) { $retString .= "]]>\n"; return $retString; } for ( $i=0; $i < $this->xnumChildren; $i++) { $retString .= $this->xchildren[$i]->getValue(); } $retString .= " ]]>\n"; return $retString; } } class MiniXMLElementDocType extends MiniXMLElement { var $dtattr; function MiniXMLElementDocType ($attr) { $this->MiniXMLElement('DOCTYPE'); $this->dtattr = $attr; } function toString ($depth) { if ($depth == MINIXML_NOWHITESPACES) { return $this->toStringNoWhiteSpaces(); } else { return $this->toStringWithWhiteSpaces($depth); } } function toStringWithWhiteSpaces ($depth=0) { $spaces = $this->_spaceStr($depth); $retString = "$spaces<!DOCTYPE " . $this->dtattr . " [\n"; if (! $this->xnumChildren) { $retString .= "]>\n"; return $retString; } $nextDepth = $depth + 1; for ( $i=0; $i < $this->xnumChildren; $i++) { $retString .= $this->xchildren[$i]->toStringWithWhiteSpaces($nextDepth); } $retString .= "\n$spaces]>\n"; return $retString; } function toStringNoWhiteSpaces () { $retString = "<!DOCTYPE " . $this->dtattr . " [ "; if (! $this->xnumChildren) { $retString .= "]>\n"; return $retString; } for ( $i=0; $i < $this->xnumChildren; $i++) { $retString .= $this->xchildren[$i]->toStringNoWhiteSpaces(); } $retString .= " ]>\n"; return $retString; } } class MiniXMLElementEntity extends MiniXMLElement { function MiniXMLElementEntity ($name, $value=NULL) { $this->MiniXMLElement($name); if (! is_null ($value)) { $this->createNode($value, 0); } } function toString ($depth = 0) { $spaces = ''; if ($depth != MINIXML_NOWHITESPACES) { $spaces = $this->_spaceStr($depth); } $retString = "$spaces<!ENTITY " . $this->name(); if (! $this->xnumChildren) { $retString .= ">\n"; return $retString; } $nextDepth = ($depth == MINIXML_NOWHITESPACES) ? MINIXML_NOWHITESPACES : $depth + 1; $retString .= '"'; for ( $i=0; $i < $this->xnumChildren; $i++) { $retString .= $this->xchildren[$i]->toString(MINIXML_NOWHITESPACES); } $retString .= '"'; $retString .= " >\n"; return $retString; } function toStringNoWhiteSpaces () { return $this->toString(MINIXML_NOWHITESPACES); } function toStringWithWhiteSpaces ($depth=0) { return $this->toString($depth); } } ?>
