<?php
 abstract class Minify_Controller_Base { abstract public function setupSources($options); public function getDefaultMinifyOptions() { return array( 'isPublic' => true ,'encodeOutput' => function_exists('gzdeflate') ,'encodeMethod' => null ,'encodeLevel' => 9 ,'minifierOptions' => array() ,'contentTypeCharset' => 'utf-8' ,'maxAge' => 1800 ,'rewriteCssUris' => true ,'bubbleCssImports' => false ,'quiet' => false ,'debug' => false ,'badRequestHeader' => 'HTTP/1.0 400 Bad Request' ,'postprocessor' => null ,'postprocessorRequire' => null ); } public function getDefaultMinifers() { $ret[Minify::TYPE_JS] = array('JSMin', 'minify'); $ret[Minify::TYPE_CSS] = array('Minify_CSS', 'minify'); $ret[Minify::TYPE_HTML] = array('Minify_HTML', 'minify'); return $ret; } public function loadMinifier($minifierCallback) { if (is_array($minifierCallback) && is_string($minifierCallback[0]) && !class_exists($minifierCallback[0], false)) { require str_replace('_', '/', $minifierCallback[0]) . '.php'; } } public static function _fileIsSafe($file, $safeDirs) { $pathOk = false; foreach ((array)$safeDirs as $safeDir) { if (strpos($file, $safeDir) === 0) { $pathOk = true; break; } } $base = basename($file); if (! $pathOk || ! is_file($file) || $base[0] === '.') { return false; } list($revExt) = explode('.', strrev($base)); return in_array(strrev($revExt), array('js', 'css', 'html', 'txt')); } public $sources = array(); public final function mixInDefaultOptions($options) { $ret = array_merge( $this->getDefaultMinifyOptions(), $options ); if (! isset($options['minifiers'])) { $options['minifiers'] = array(); } $ret['minifiers'] = array_merge( $this->getDefaultMinifers(), $options['minifiers'] ); return $ret; } public final function analyzeSources($options = array()) { if ($this->sources) { if (! isset($options['contentType'])) { $options['contentType'] = Minify_Source::getContentType($this->sources); } if (! isset($options['lastModifiedTime'])) { $max = 0; foreach ($this->sources as $source) { $max = max($source->lastModified, $max); } $options['lastModifiedTime'] = $max; } } return $options; } protected function log($msg) { require_once 'Minify/Logger.php'; Minify_Logger::log($msg); } } 