<?php
if(!$this) { header('Location:../');exit; } $Tables = $this->_DB->getProjectTablesStatus(); ?>
<!doctype html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Mizu:Debug</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css" rel="stylesheet">
    <?php echo $this->getHeader(); ?>
    <style>
        .btn {
            text-align:left;
            white-space: normal;
        }
        h1 a {
           color:black;
            text-decoration:none !important;
        }
    </style>
</head>
<body>
<div class="container">
    <h1><a href="?mizu=debug"><img src="mizu/img/logo.png"> Mizu - Debug</a></h1>

    <?php if($Mizu->GP['alert']) : ?>
        <div class="alert alert-success">
            <?= stripslashes(urldecode($Mizu->GP['alert'])) ?>
        </div>
    <?php endif ?>



<?php if($Mizu->GP['a']=='cacheList') : $dir='cache/'; ?>
    <h2>Cache-List</h2>
    <table class="table table-striped">



    <?php foreach(scandir($dir) as $v) : if(substr($v,0,4)!='tpl-' OR substr($v,-4)!='.php') continue; $f = $dir.$v; $myfile = fopen($f, "r"); $t = fread($myfile,filesize($f)); fclose($myfile); $A = explode($Mizu->CachSep,$t); $V = array( 'time' => $A[1], 'opt' => $this->MyJsonDecode($A[3]), ); ?>
        <tr>
            <td><?= date('d.m.Y H:i',$V['time']) ?></td>
            <td><?= $V['opt']['url'] ?></td>
        </tr>
    <?php endforeach ?>

    </table>
<?php else : ?>
    <div class="row">
        <div class="col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    Datenbank
                </div>
                <div class="panel-body">
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'resyncTables')) ?>" class="btn btn-primary">
                            <span class="glyphicon glyphicon-ok"></span> Datenbank synchronisieren
                        </a></p>
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'exportDB')) ?>" class="btn btn-primary">
                            <span class="glyphicon glyphicon-ok"></span> Datenbank exportieren
                        </a></p>
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'controllAliasUrl')) ?>" class="btn btn-danger">
                            <span class="glyphicon glyphicon-ok"></span> Alle ALIASE korrigieren
                        </a></p>

                    <?php if($Tables) : ?>
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th>Engine</th>
                            </tr>
                            </thead>
                        <?php foreach($Tables as $k => $table) : ?>
                            <tr>
                                <td><?= $table['Name'] ?></td>
                                <td><?= $table['Engine'] ?></td>
                            </tr>
                        <?php endforeach ?>
                        </table>


                        <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'convertDBintoMyIsam')) ?>" class="btn btn-danger">
                                <span class="glyphicon glyphicon-ok"></span> Tabellen in MyIsam umwandeln (wichtig für cache)
                            </a>

                        <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'convertDBintoUTF8')) ?>" class="btn btn-danger">
                                <span class="glyphicon glyphicon-ok"></span> Alle Felder in UTF8 umwandeln (defaultChartSet muss utf8 sein)
                            </a>
                        </p>

                    <?php endif ?>


                    <form action="<?= $this->getUrl(false,false) ?>" class="form">
                        <input type="hidden" name="mizu" value="copytables">
                        <input type="text" name="prefix" class="form-control" placeholder="prefix_" style="width:250px;float:left;"/>
                        <button type="submit" class="btn btn-success">
                            <span class="glyphicon glyphicon-ok"></span>
                            Tabellen kopieren
                        </button>
                    </form>

                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    Übersetzungen
                </div>
                <div class="panel-body">
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'exportLng')) ?>" class="btn btn-info">
                            <span class="glyphicon glyphicon-ok"></span> Alle lng.xml anzeigen
                        </a>
                        <a href="<?= $this->getUrl(false,false,array('mizu'=>'exportLngProjectFields')) ?>" class="btn btn-primary">
                            <span class="glyphicon glyphicon-ok"></span> Projekt Felder anzeigen
                        </a>

                    </p>
                    <form action="<?= $this->getUrl() ?>" class="form-inline">
                        <input type="hidden" name="mizu" value="exportXLIFF"/>
                        <select name="lng" class="form-control">



                            <?php foreach($Mizu->allowLngs as $k => $l) : if(is_array($Mizu->project['conf']['lngs'][$l]['attr']) AND $Mizu->project['conf']['lngs'][$l]['attr']['name']) { $e = $Mizu->project['conf']['lngs'][$l]['attr']['name']; } else { $e = $l; } ?>
                                <option value="<?= $l ?>"><?= $e ?></option>
                            <?php endforeach ; ?>

                        </select>
                        <button type="submit" class="btn btn-info">
                            <span class="glyphicon glyphicon-ok"></span> xliff Dateien exportieren
                        </button>
                    </form>


                    </p>


                    <p>
                    <form action="<?= $this->getUrl() ?>" class="form-inline"  method="post" enctype="multipart/form-data">
                        <input type="hidden" name="mizu" value="importXLIFF"/>
                        <label>ZIP-File:</label>
                        <input type="file" name="file" class="form-control"/>
                        <label>Target:</label>
                        <select name="lng" class="form-control">
                            <?php foreach($Mizu->allowLngs as $k => $l) : if(is_array($Mizu->project['conf']['lngs'][$l]['attr']) AND $Mizu->project['conf']['lngs'][$l]['attr']['name']) { $e = $Mizu->project['conf']['lngs'][$l]['attr']['name']; } else { $e = $l; } ?>
                                <option value="<?= $l ?>"><?= $e ?></option>
                            <?php endforeach ; ?>

                        </select>
                        <button type="submit" class="btn btn-info">
                            <span class="glyphicon glyphicon-ok"></span> xliff Dateien importieren
                        </button>
                    </form>


                    </p>
                </div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    Cache
                </div>
                <div class="panel-body">
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'clearPageCache')) ?>" class="btn btn-primary">
                            <span class="glyphicon glyphicon-ok"></span> Mizu nur den Seiten-Cache löschen
                        </a></p>
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'debug','a'=>'cacheList')) ?>" class="btn btn-info">
                            <span class="glyphicon glyphicon-ok"></span> Cache urls anzeigen
                        </a></p>
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'clearALL')) ?>" class="btn btn-danger">
                            <span class="glyphicon glyphicon-ok"></span> Gelöschte Seiten für IMMER entfernen
                        </a></p>
                </div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    Tools
                </div>
                <div class="panel-body">
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'httpsCheck')) ?>" class="btn btn-primary">
                            <span class="glyphicon glyphicon-ok"></span> HTTPS Check
                        </a></p>
                </div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    Filepool
                </div>
                <div class="panel-body">
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'recalcImg')) ?>" class="btn btn-danger">
                            <span class="glyphicon glyphicon-ok"></span> Bilder neu berechnen und umbenennen (muss mehrfach ausgeführt werden)
                        </a></p>

                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'renameImg')) ?>" class="btn btn-danger">
                            <span class="glyphicon glyphicon-ok"></span> Bilder und Ordner umbenennen (muss mehrfach ausgeführt werden)
                        </a></p>
                </div>
            </div>
        </div>

        <?php if($Mizu->Conf['ENV']=='local') : ?>
            <div class="col-sm-6">
                <div class="panel panel-warning">
                    <div class="panel-heading">
                        LOCAL
                    </div>
                    <div class="panel-body">
                        <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'check-shorttags')) ?>" class="btn btn-danger">
                                <span class="glyphicon glyphicon-ok"></span> PHP ShortTags korrigieren
                            </a>
                            <a href="<?= $this->getUrl(false,false,array('mizu'=>'set-antispam')) ?>" class="btn btn-danger">
                                <span class="glyphicon glyphicon-ok"></span> Install Antispam
                            </a>
                            <a href="<?= $this->getUrl(false,false,array('mizu'=>'check-php8')) ?>" class="btn btn-danger">
                                <span class="glyphicon glyphicon-ok"></span> Check PHP8
                            </a>



                        </p>




                    </div>
                </div>
            </div>
        <?php endif ?>



        <div class="col-sm-12">
            <div class="panel panel-info">
                <div class="panel-heading">
                    Server Infos
                </div>
                <div class="panel-body">
                    <?php if($this->_DB->dbType=='pdo') : ?>
                        <div class="alert alert-success">DB secure - PDO is active</div>
                    <?php else : ?>
                        <div class="alert alert-danger">DB insecure - use PDO if possible</div>
                    <?php endif ?>
                    <?php $GLOBALS['formDebug']=1; include('check.php'); ?>
                </div>
            </div>


        </div>
    </div>
</div>
<?php endif ?>


</body>
</html>

