<?php
 class Minify_YUICompressor { public static $jarFile = null; public static $tempDir = null; public static $javaExecutable = 'java'; public static function minifyJs($js, $options = array()) { return self::_minify('js', $js, $options); } public static function minifyCss($css, $options = array()) { return self::_minify('css', $css, $options); } private static function _minify($type, $content, $options) { self::_prepare(); if (! ($tmpFile = tempnam(self::$tempDir, 'yuic_'))) { throw new Exception('Minify_YUICompressor : could not create temp file.'); } file_put_contents($tmpFile, $content); exec(self::_getCmd($options, $type, $tmpFile), $output); unlink($tmpFile); return implode("\n", $output); } private static function _getCmd($userOptions, $type, $tmpFile) { $o = array_merge( array( 'charset' => '' ,'line-break' => 5000 ,'type' => $type ,'nomunge' => false ,'preserve-semi' => false ,'disable-optimizations' => false ) ,$userOptions ); $cmd = self::$javaExecutable . ' -jar ' . escapeshellarg(self::$jarFile) . " --type {$type}" . (preg_match('/^[a-zA-Z\\-]+$/', $o['charset']) ? " --charset {$o['charset']}" : '') . (is_numeric($o['line-break']) && $o['line-break'] >= 0 ? ' --line-break ' . (int)$o['line-break'] : ''); if ($type === 'js') { foreach (array('nomunge', 'preserve-semi', 'disable-optimizations') as $opt) { $cmd .= $o[$opt] ? " --{$opt}" : ''; } } return $cmd . ' ' . escapeshellarg($tmpFile); } private static function _prepare() { if (! is_file(self::$jarFile) || ! is_dir(self::$tempDir) || ! is_writable(self::$tempDir) ) { throw new Exception('Minify_YUICompressor : $jarFile and $tempDir must be set.'); } } } 