<?php
 $Tables = $this->_DB->getProjectTablesStatus(); ?>
<!doctype html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Mizu:Debug</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css" rel="stylesheet">
    <?php
 echo $this->getHeader(); ?>
    <style>
        .btn {
            text-align:left;
            white-space: normal;
        }
    </style>
</head>
<body>
<div class="container">
    <h1><img src="mizu/img/logo.png"> Mizu - Debug</h1>

    <div class="row">

        <div class="col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    Datenbank
                </div>
                <div class="panel-body">
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'resyncTables')) ?>" class="btn btn-primary">
                            <span class="glyphicon glyphicon-ok"></span> Datenbank synchronisieren
                        </a></p>
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'exportDB')) ?>" class="btn btn-primary">
                            <span class="glyphicon glyphicon-ok"></span> Datenbank exportieren
                        </a></p>
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'clearAliasUrl')) ?>" class="btn btn-danger">
                            <span class="glyphicon glyphicon-ok"></span> Alle Urls resetieren (vor online wichtig!)
                        </a></p>

                    <?php if($Tables) : ?>
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th>Engine</th>
                            </tr>
                            </thead>
                        <?php foreach($Tables as $k => $table) : ?>
                            <tr>
                                <td><?= $table['Name'] ?></td>
                                <td><?= $table['Engine'] ?></td>
                            </tr>
                        <?php endforeach ?>
                        </table>


                        <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'convertDBintoMyIsam')) ?>" class="btn btn-danger">
                                <span class="glyphicon glyphicon-ok"></span> Tabellen in MyIsam umwandeln (wichtig für cache)
                            </a></p>

                    <?php endif ?>

                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    Infos
                </div>
                <div class="panel-body">
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'exportLng')) ?>" class="btn btn-info">
                            <span class="glyphicon glyphicon-ok"></span> Alle Übersetzungen anzeigen
                        </a></p>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    Cache
                </div>
                <div class="panel-body">
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'clearPageCache')) ?>" class="btn btn-primary">
                            <span class="glyphicon glyphicon-ok"></span> Mizu nur den Seiten-Cache löschen
                        </a></p>
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'clearALL')) ?>" class="btn btn-danger">
                            <span class="glyphicon glyphicon-ok"></span> Gelöschte Seiten für IMMER entfernen
                        </a></p>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    Filepool
                </div>
                <div class="panel-body">
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'recalcImg')) ?>" class="btn btn-danger">
                            <span class="glyphicon glyphicon-ok"></span> Bilder neu berechnen und umbenennen (muss mehrfach ausgeführt werden)
                        </a></p>
                    <p><a href="<?= $this->getUrl(false,false,array('mizu'=>'renameImg')) ?>" class="btn btn-danger">
                            <span class="glyphicon glyphicon-ok"></span> Bilder und Ordner umbenennen (muss mehrfach ausgeführt werden)
                        </a></p>
                </div>
            </div>
        </div>
        <div class="col-sm-12">
            <div class="panel panel-info">
                <div class="panel-heading">
                    Server Infos
                </div>
                <div class="panel-body">
                    <?php $GLOBALS['formDebug']=1; include('check.php'); ?>
                </div>
            </div>


        </div>
    </div>
</div>



</body>
</html>

