<?php
 require_once 'Minify/Source.php'; class Minify { const VERSION = '2.1.3'; const TYPE_CSS = 'text/css'; const TYPE_HTML = 'text/html'; const TYPE_JS = 'application/x-javascript'; public static $uploaderHoursBehind = 0; public static $importWarning = "/* See http://code.google.com/p/minify/wiki/CommonProblems#@imports_can_appear_in_invalid_locations_in_combined_CSS_files */\n"; public static function setCache($cache = '', $fileLocking = true) { if (is_string($cache)) { require_once 'Minify/Cache/File.php'; self::$_cache = new Minify_Cache_File($cache, $fileLocking); } else { self::$_cache = $cache; } } public static function serve($controller, $options = array()) { if (is_string($controller)) { $class = 'Minify_Controller_' . $controller; if (! class_exists($class, false)) { require_once "Minify/Controller/" . str_replace('_', '/', $controller) . ".php"; } $controller = new $class(); } $options = $controller->setupSources($options); $options = $controller->analyzeSources($options); self::$_options = $controller->mixInDefaultOptions($options); if (! $controller->sources) { if (! self::$_options['quiet']) { header(self::$_options['badRequestHeader']); echo self::$_options['badRequestHeader']; return; } else { list(,$statusCode) = explode(' ', self::$_options['badRequestHeader']); return array( 'success' => false ,'statusCode' => (int)$statusCode ,'content' => '' ,'headers' => array() ); } } self::$_controller = $controller; if (self::$_options['debug']) { self::_setupDebug($controller->sources); self::$_options['maxAge'] = 0; } if (self::$_options['encodeOutput']) { if (self::$_options['encodeMethod'] !== null) { $contentEncoding = self::$_options['encodeMethod']; } else { require_once 'HTTP/Encoder.php'; list(self::$_options['encodeMethod'], $contentEncoding) = HTTP_Encoder::getAcceptedEncoding(false, false); } } else { self::$_options['encodeMethod'] = ''; } require_once 'HTTP/ConditionalGet.php'; $cgOptions = array( 'lastModifiedTime' => self::$_options['lastModifiedTime'] ,'isPublic' => self::$_options['isPublic'] ,'encoding' => self::$_options['encodeMethod'] ); if (self::$_options['maxAge'] > 0) { $cgOptions['maxAge'] = self::$_options['maxAge']; } $cg = new HTTP_ConditionalGet($cgOptions); if ($cg->cacheIsValid) { if (! self::$_options['quiet']) { $cg->sendHeaders(); return; } else { return array( 'success' => true ,'statusCode' => 304 ,'content' => '' ,'headers' => $cg->getHeaders() ); } } else { $headers = $cg->getHeaders(); unset($cg); } if (self::$_options['contentType'] === self::TYPE_CSS && self::$_options['rewriteCssUris']) { reset($controller->sources); while (list($key, $source) = each($controller->sources)) { if ($source->filepath && !isset($source->minifyOptions['currentDir']) && !isset($source->minifyOptions['prependRelativePath']) ) { $source->minifyOptions['currentDir'] = dirname($source->filepath); } } } if (null !== self::$_cache) { $cacheId = 'minify_' . self::_getCacheId(); $fullCacheId = (self::$_options['encodeMethod']) ? $cacheId . '.gz' : $cacheId; $cacheIsReady = self::$_cache->isValid($fullCacheId, self::$_options['lastModifiedTime']); if ($cacheIsReady) { $cacheContentLength = self::$_cache->getSize($fullCacheId); } else { $content = self::_combineMinify(); self::$_cache->store($cacheId, $content); if (function_exists('gzencode')) { self::$_cache->store($cacheId . '.gz', gzencode($content, self::$_options['encodeLevel'])); } } } else { $cacheIsReady = false; $content = self::_combineMinify(); } if (! $cacheIsReady && self::$_options['encodeMethod']) { $content = gzencode($content, self::$_options['encodeLevel']); } $headers['Content-Length'] = $cacheIsReady ? $cacheContentLength : strlen($content); $headers['Content-Type'] = self::$_options['contentTypeCharset'] ? self::$_options['contentType'] . '; charset=' . self::$_options['contentTypeCharset'] : self::$_options['contentType']; if (self::$_options['encodeMethod'] !== '') { $headers['Content-Encoding'] = $contentEncoding; } if (self::$_options['encodeOutput']) { $headers['Vary'] = 'Accept-Encoding'; } if (! self::$_options['quiet']) { foreach ($headers as $name => $val) { header($name . ': ' . $val); } if ($cacheIsReady) { self::$_cache->display($fullCacheId); } else { echo $content; } } else { return array( 'success' => true ,'statusCode' => 200 ,'content' => $cacheIsReady ? self::$_cache->fetch($fullCacheId) : $content ,'headers' => $headers ); } } public static function combine($sources, $options = array()) { $cache = self::$_cache; self::$_cache = null; $options = array_merge(array( 'files' => (array)$sources ,'quiet' => true ,'encodeMethod' => '' ,'lastModifiedTime' => 0 ), $options); $out = self::serve('Files', $options); self::$_cache = $cache; return $out['content']; } public static function setDocRoot($unsetPathInfo = false) { if (isset($_SERVER['SERVER_SOFTWARE']) && 0 === strpos($_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS/') ) { $_SERVER['DOCUMENT_ROOT'] = rtrim(substr( $_SERVER['PATH_TRANSLATED'] ,0 ,strlen($_SERVER['PATH_TRANSLATED']) - strlen($_SERVER['SCRIPT_NAME']) ), '\\'); if ($unsetPathInfo) { unset($_SERVER['PATH_INFO']); } require_once 'Minify/Logger.php'; Minify_Logger::log("setDocRoot() set DOCUMENT_ROOT to \"{$_SERVER['DOCUMENT_ROOT']}\""); } } private static $_cache = null; protected static $_controller = null; protected static $_options = null; protected static function _setupDebug($sources) { foreach ($sources as $source) { $source->minifier = array('Minify_Lines', 'minify'); $id = $source->getId(); $source->minifyOptions = array( 'id' => (is_file($id) ? basename($id) : $id) ); } } protected static function _combineMinify() { $type = self::$_options['contentType']; $implodeSeparator = ($type === self::TYPE_JS) ? "\n;" : ''; $defaultOptions = isset(self::$_options['minifierOptions'][$type]) ? self::$_options['minifierOptions'][$type] : array(); $defaultMinifier = isset(self::$_options['minifiers'][$type]) ? self::$_options['minifiers'][$type] : false; if (Minify_Source::haveNoMinifyPrefs(self::$_controller->sources)) { foreach (self::$_controller->sources as $source) { $pieces[] = $source->getContent(); } $content = implode($implodeSeparator, $pieces); if ($defaultMinifier) { self::$_controller->loadMinifier($defaultMinifier); $content = call_user_func($defaultMinifier, $content, $defaultOptions); } } else { foreach (self::$_controller->sources as $source) { $minifier = (null !== $source->minifier) ? $source->minifier : $defaultMinifier; $options = (null !== $source->minifyOptions) ? array_merge($defaultOptions, $source->minifyOptions) : $defaultOptions; if ($minifier) { self::$_controller->loadMinifier($minifier); $pieces[] = call_user_func($minifier, $source->getContent(), $options); } else { $pieces[] = $source->getContent(); } } $content = implode($implodeSeparator, $pieces); } if ($type === self::TYPE_CSS && false !== strpos($content, '@import')) { $content = self::_handleCssImports($content); } if (self::$_options['postprocessorRequire']) { require_once self::$_options['postprocessorRequire']; } if (self::$_options['postprocessor']) { $content = call_user_func(self::$_options['postprocessor'], $content, $type); } return $content; } protected static function _getCacheId() { return md5(serialize(array( Minify_Source::getDigest(self::$_controller->sources) ,self::$_options['minifiers'] ,self::$_options['minifierOptions'] ,self::$_options['postprocessor'] ,self::$_options['bubbleCssImports'] ))); } protected static function _handleCssImports($css) { if (self::$_options['bubbleCssImports']) { preg_match_all('/@import.*?;/', $css, $imports); $css = implode('', $imports[0]) . preg_replace('/@import.*?;/', '', $css); } else if ('' !== self::$importWarning) { $noCommentCss = preg_replace('@/\\*[\\s\\S]*?\\*/@', '', $css); $lastImportPos = strrpos($noCommentCss, '@import'); $firstBlockPos = strpos($noCommentCss, '{'); if (false !== $lastImportPos && false !== $firstBlockPos && $firstBlockPos < $lastImportPos ) { $css = self::$importWarning . $css; } } return $css; } } 