<?php
 class Minify_HTML { function minify($html, $options = array()) { $min = new Minify_HTML($html, $options); return $min->process(); } function __construct($html, $options = array()) { $this->_html = str_replace("\r\n", "\n", trim($html)); if (isset($options['xhtml'])) { $this->_isXhtml = (bool)$options['xhtml']; } if (isset($options['cssMinifier'])) { $this->_cssMinifier = $options['cssMinifier']; } if (isset($options['jsMinifier'])) { $this->_jsMinifier = $options['jsMinifier']; } } function process() { if ($this->_isXhtml === null) { $this->_isXhtml = (false !== strpos($this->_html, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML')); } $this->_replacementHash = 'MINIFYHTML' . md5($_SERVER['REQUEST_TIME']); $this->_placeholders = array(); $this->_html = preg_replace_callback( '/(\\s*)(<script\\b[^>]*?>)([\\s\\S]*?)<\\/script>(\\s*)/i' ,array($this, '_removeScriptCB') ,$this->_html); $this->_html = preg_replace_callback( '/\\s*(<style\\b[^>]*?>)([\\s\\S]*?)<\\/style>\\s*/i' ,array($this, '_removeStyleCB') ,$this->_html); $this->_html = preg_replace_callback( '/<!--([\\s\\S]*?)-->/' ,array($this, '_commentCB') ,$this->_html); $this->_html = preg_replace_callback('/\\s*(<pre\\b[^>]*?>[\\s\\S]*?<\\/pre>)\\s*/i' ,array($this, '_removePreCB') ,$this->_html); $this->_html = preg_replace_callback( '/\\s*(<textarea\\b[^>]*?>[\\s\\S]*?<\\/textarea>)\\s*/i' ,array($this, '_removeTextareaCB') ,$this->_html); $this->_html = preg_replace('/^\\s+|\\s+$/m', '', $this->_html); $this->_html = preg_replace('/\\s+(<\\/?(?:area|base(?:font)?|blockquote|body' .'|caption|center|cite|col(?:group)?|dd|dir|div|dl|dt|fieldset|form' .'|frame(?:set)?|h[1-6]|head|hr|html|legend|li|link|map|menu|meta' .'|ol|opt(?:group|ion)|p|param|t(?:able|body|head|d|h||r|foot|itle)' .'|ul)\\b[^>]*>)/i', '$1', $this->_html); $this->_html = preg_replace_callback( '/>([^<]+)</' ,array($this, '_outsideTagCB') ,$this->_html); $this->_html = preg_replace('/(<[a-z\\-]+)\\s+([^>]+>)/i', "$1\n$2", $this->_html); $this->_html = str_replace( array_keys($this->_placeholders) ,array_values($this->_placeholders) ,$this->_html ); return $this->_html; } function _commentCB($m) { return (0 === strpos($m[1], '[') || false !== strpos($m[1], '<![')) ? $m[0] : ''; } function _reservePlace($content) { $placeholder = '%' . $this->_replacementHash . count($this->_placeholders) . '%'; $this->_placeholders[$placeholder] = $content; return $placeholder; } var $_isXhtml = null; var $_replacementHash = null; var $_placeholders = array(); var $_cssMinifier = null; var $_jsMinifier = null; function _outsideTagCB($m) { return '>' . preg_replace('/^\\s+|\\s+$/', ' ', $m[1]) . '<'; } function _removePreCB($m) { return $this->_reservePlace($m[1]); } function _removeTextareaCB($m) { return $this->_reservePlace($m[1]); } function _removeStyleCB($m) { $openStyle = $m[1]; $css = $m[2]; $css = preg_replace('/(?:^\\s*<!--|-->\\s*$)/', '', $css); $css = $this->_removeCdata($css); $minifier = $this->_cssMinifier ? $this->_cssMinifier : 'trim'; $css = call_user_func($minifier, $css); return $this->_reservePlace($this->_needsCdata($css) ? "{$openStyle}/*<![CDATA[*/{$css}/*]]>*/</style>" : "{$openStyle}{$css}</style>" ); } function _removeScriptCB($m) { $openScript = $m[2]; $js = $m[3]; $ws1 = ($m[1] === '') ? '' : ' '; $ws2 = ($m[4] === '') ? '' : ' '; $js = preg_replace('/(?:^\\s*<!--\\s*|\\s*(?:\\/\\/)?\\s*-->\\s*$)/', '', $js); $js = $this->_removeCdata($js); $minifier = $this->_jsMinifier ? $this->_jsMinifier : 'trim'; $js = call_user_func($minifier, $js); return $this->_reservePlace($this->_needsCdata($js) ? "{$ws1}{$openScript}/*<![CDATA[*/{$js}/*]]>*/</script>{$ws2}" : "{$ws1}{$openScript}{$js}</script>{$ws2}" ); } function _removeCdata($str) { return (false !== strpos($str, '<![CDATA[')) ? str_replace(array('<![CDATA[', ']]>'), '', $str) : $str; } function _needsCdata($str) { return ($this->_isXhtml && preg_match('/(?:[<&]|\\-\\-|\\]\\]>)/', $str)); } } 